/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.time.Clock;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.concurrent.atomic.LongAdder;
import org.neo4j.kernel.api.index.IndexUsageStats;
import org.neo4j.kernel.impl.index.schema.IndexUsageTracker;
import org.neo4j.kernel.impl.index.schema.IndexUsageTracking;

public class DefaultIndexUsageTracking
implements IndexUsageTracking {
    private final long trackedSince;
    private final LongAdder readCount = new LongAdder();
    private final LongAccumulator lastRead = new LongAccumulator(Long::max, 0L);
    private final Clock clock;

    public DefaultIndexUsageTracking(Clock clock) {
        this.clock = clock;
        this.trackedSince = clock.millis();
    }

    @Override
    public IndexUsageTracker track() {
        return new DefaultIndexUsageTracker();
    }

    @Override
    public IndexUsageStats getAndReset() {
        long queryCount = this.readCount.sumThenReset();
        return new IndexUsageStats(this.lastRead.longValue(), queryCount, this.trackedSince);
    }

    private void add(long queryCount, long lastTimeUsed) {
        this.readCount.add(queryCount);
        this.lastRead.accumulate(lastTimeUsed);
    }

    private class DefaultIndexUsageTracker
    implements IndexUsageTracker {
        private long localLastRead;
        private long localReadCount;

        private DefaultIndexUsageTracker() {
        }

        @Override
        public void queried() {
            ++this.localReadCount;
            this.localLastRead = DefaultIndexUsageTracking.this.clock.millis();
        }

        @Override
        public void close() {
            DefaultIndexUsageTracking.this.add(this.localReadCount, this.localLastRead);
        }
    }
}

