/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import org.neo4j.token.TokenHolders;

public interface ReadBehaviour {
    public static final ReadBehaviour INCLUSIVE_STRICT = new Adapter(){

        @Override
        public void error(String format, Object ... parameters) {
            throw new RuntimeException(String.format(format, parameters));
        }

        @Override
        public void error(Throwable e, String format, Object ... parameters) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(String.format(format, parameters), e);
        }
    };

    public boolean shouldIncludeNode(long var1, String[] var3);

    default public long translateNodeId(long nodeId) {
        return nodeId;
    }

    public boolean shouldIncludeRelationship(long var1, long var3, long var5, String var7);

    default public long translateRelationshipId(long relationshipId) {
        return relationshipId;
    }

    default public long translateRelationshipStartNodeId(long relationshipId, long startNodeId, long endNodeId) {
        return startNodeId;
    }

    default public long translateRelationshipEndNodeId(long relationshipId, long startNodeId, long endNodeId) {
        return endNodeId;
    }

    public String[] filterLabels(String[] var1);

    public boolean shouldIncludeNodeProperty(String var1, String[] var2, boolean var3);

    public boolean shouldIncludeRelationshipProperty(String var1, String var2);

    public void unused();

    public void removed();

    public void error(String var1, Object ... var2);

    public void error(Throwable var1, String var2, Object ... var3);

    public TokenHolders decorateTokenHolders(TokenHolders var1);

    public static class Adapter
    implements ReadBehaviour {
        @Override
        public boolean shouldIncludeNode(long nodeId, String[] labels) {
            return true;
        }

        @Override
        public boolean shouldIncludeRelationship(long startNodeId, long endNodeId, long relationshipId, String relationshipType) {
            return true;
        }

        @Override
        public String[] filterLabels(String[] labels) {
            return labels;
        }

        @Override
        public boolean shouldIncludeNodeProperty(String propertyKey, String[] labels, boolean completeMatch) {
            return true;
        }

        @Override
        public boolean shouldIncludeRelationshipProperty(String propertyKey, String relationshipType) {
            return true;
        }

        @Override
        public void unused() {
        }

        @Override
        public void removed() {
        }

        @Override
        public void error(String format, Object ... parameters) {
        }

        @Override
        public void error(Throwable e, String format, Object ... parameters) {
        }

        @Override
        public TokenHolders decorateTokenHolders(TokenHolders actual) {
            return actual;
        }
    }
}

