/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

import java.util.Arrays;
import org.eclipse.collections.api.iterator.LongIterator;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.collection.trackable.HeapTrackingArrayList;
import org.neo4j.collection.trackable.HeapTrackingIntArrayList;
import org.neo4j.graphdb.Direction;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.RelationshipDirection;
import org.neo4j.storageengine.api.txstate.NodeState;

public final class DirectedTypes {
    private final HeapTrackingIntArrayList types;
    private final HeapTrackingArrayList<Direction> directions;
    private DirectionCombination untyped;
    private DirectionCombination existingDirections;
    private boolean isCompacted;

    private DirectedTypes(HeapTrackingIntArrayList types, HeapTrackingArrayList<Direction> directions, DirectionCombination untyped, DirectionCombination existingDirections) {
        this.types = types;
        this.directions = directions;
        this.untyped = untyped;
        this.existingDirections = existingDirections;
        this.isCompacted = true;
    }

    public DirectedTypes(MemoryTracker memoryTracker) {
        this(HeapTrackingIntArrayList.newIntArrayList((MemoryTracker)memoryTracker), (HeapTrackingArrayList<Direction>)HeapTrackingArrayList.newArrayList((MemoryTracker)memoryTracker), DirectionCombination.Neither, DirectionCombination.Neither);
    }

    private boolean hasTypeInDirection(int type, RelationshipDirection direction) {
        int i = this.types.indexOf(type);
        return i != -1 && direction.matches((Direction)this.directions.get(i));
    }

    public boolean hasOutgoing(int type) {
        return this.untyped.matchesOutgoing() || this.hasTypeInDirection(type, RelationshipDirection.OUTGOING);
    }

    public boolean hasIncoming(int type) {
        return this.untyped.matchesIncoming() || this.hasTypeInDirection(type, RelationshipDirection.INCOMING);
    }

    public boolean hasEither(int type) {
        return this.untyped.matchesLoop() || this.hasTypeInDirection(type, RelationshipDirection.LOOP);
    }

    public Direction computeDirection() {
        return switch (this.existingDirections) {
            default -> throw new IncompatibleClassChangeError();
            case DirectionCombination.Outgoing -> Direction.OUTGOING;
            case DirectionCombination.Incoming -> Direction.INCOMING;
            case DirectionCombination.Both -> Direction.BOTH;
            case DirectionCombination.Neither -> throw new IllegalStateException("This should not happen");
        };
    }

    public Direction direction(int type) {
        int i = this.types.indexOf(type);
        return i != -1 ? this.untyped.combine((Direction)this.directions.get(i)) : this.untyped.direction;
    }

    public boolean hasSomeOutgoing() {
        return this.existingDirections.matchesOutgoing();
    }

    public boolean hasSomeIncoming() {
        return this.existingDirections.matchesIncoming();
    }

    public boolean hasTypesInBothDirections() {
        return this.existingDirections == DirectionCombination.Both;
    }

    public boolean isTypeLimited() {
        return this.untyped == DirectionCombination.Neither;
    }

    public int numberOfCriteria() {
        this.compact();
        return this.types.size() + this.untyped.numberOfCriteria();
    }

    public Direction criterionDirection(int index) {
        this.compact();
        if (index < this.types.size()) {
            return (Direction)this.directions.get(index);
        }
        if (this.untyped.numberOfCriteria() == 1) {
            assert (index == this.types.size()) : "Index out of bounds that we don't pay for checking when assertions are turned off";
            return switch (this.untyped) {
                default -> throw new IncompatibleClassChangeError();
                case DirectionCombination.Outgoing -> Direction.OUTGOING;
                case DirectionCombination.Incoming -> Direction.INCOMING;
                case DirectionCombination.Both -> Direction.BOTH;
                case DirectionCombination.Neither -> throw new IllegalStateException("The numberOfCriteria returned from Neither is 0 so this should never happen");
            };
        }
        throw new IndexOutOfBoundsException(index);
    }

    public int criterionType(int index) {
        this.compact();
        if (index < this.types.size()) {
            return this.types.get(index);
        }
        if (this.untyped != DirectionCombination.Neither) {
            assert (index == this.types.size()) : "Index out of bounds that we don't pay for checking when assertions are turned off";
            return -1;
        }
        throw new IndexOutOfBoundsException(index);
    }

    public boolean allowsAllIncoming() {
        return this.untyped.matchesIncoming();
    }

    public boolean allowsAllOutgoing() {
        return this.untyped.matchesOutgoing();
    }

    public boolean allowsAll() {
        return this.untyped == DirectionCombination.Both;
    }

    public void addUntyped(Direction direction) {
        if (!this.untyped.matchesDirection(direction)) {
            this.isCompacted = false;
            this.untyped = this.untyped.addDirection(direction);
            this.existingDirections = this.existingDirections.addDirection(direction);
        }
    }

    public void addTypes(int[] newTypes, Direction direction) {
        if (newTypes == null) {
            this.addUntyped(direction);
        } else {
            if (this.untyped.matchesDirection(direction)) {
                return;
            }
            for (int newType : newTypes) {
                this.addType(newType, direction);
            }
        }
    }

    private void addType(int newType, Direction direction) {
        int insertionIndex = -1;
        for (int i = 0; i < this.types.size(); ++i) {
            int type = this.types.get(i);
            if (type == newType) {
                Direction existingDirection = (Direction)this.directions.get(i);
                if (existingDirection != Direction.BOTH && existingDirection != direction) {
                    this.directions.set(i, (Object)Direction.BOTH);
                    this.existingDirections = DirectionCombination.Both;
                }
                return;
            }
            if (newType >= type) continue;
            insertionIndex = i;
            break;
        }
        if (insertionIndex != -1) {
            this.types.add(insertionIndex, newType);
            this.directions.add(insertionIndex, (Object)direction);
        } else {
            this.types.add(newType);
            this.directions.add((Object)direction);
        }
        this.existingDirections = this.existingDirections.addDirection(direction);
    }

    public DirectedTypes reverse() {
        if (this.untyped == DirectionCombination.Both) {
            DirectedTypes reverse = new DirectedTypes(this.types.clone(), (HeapTrackingArrayList<Direction>)this.directions.clone(), this.untyped, this.existingDirections);
            reverse.isCompacted = this.isCompacted;
            return reverse;
        }
        HeapTrackingArrayList reversedDirections = this.directions.clone();
        reversedDirections.replaceAll(Direction::reverse);
        DirectedTypes reverse = new DirectedTypes(this.types.clone(), (HeapTrackingArrayList<Direction>)reversedDirections, this.untyped.reverse(), this.existingDirections.reverse());
        reverse.isCompacted = this.isCompacted;
        return reverse;
    }

    public void clear() {
        this.untyped = DirectionCombination.Neither;
        this.existingDirections = DirectionCombination.Neither;
        this.types.clear();
        this.directions.clear();
        this.isCompacted = true;
    }

    public void compact() {
        int readIndex;
        if (this.isCompacted || this.untyped == DirectionCombination.Neither) {
            this.isCompacted = true;
            return;
        }
        if (this.untyped == DirectionCombination.Both) {
            this.types.truncate(0);
            this.directions.truncate(0);
            this.isCompacted = true;
            return;
        }
        int writeIndex = 0;
        for (readIndex = 0; readIndex < this.types.size(); ++readIndex) {
            Direction direction = (Direction)this.directions.get(readIndex);
            if (this.untyped.matchesDirection(direction)) continue;
            if (writeIndex != readIndex) {
                this.types.set(writeIndex, this.types.get(readIndex));
                this.directions.set(writeIndex, (Object)((Direction)this.directions.get(readIndex)));
            }
            ++writeIndex;
        }
        if (writeIndex != readIndex) {
            this.types.truncate(writeIndex);
            this.directions.truncate(writeIndex);
        }
        this.isCompacted = true;
    }

    public int[] typesWithoutDirections() {
        if (this.untyped.numberOfCriteria() != 0) {
            return null;
        }
        return this.types.toArray();
    }

    private LongIterator addedRelationshipsInner(NodeState transactionState, RelationshipDirection relDirection) {
        LongIterator[] all = new LongIterator[this.types.size()];
        int index = 0;
        for (int i = 0; i < this.types.size(); ++i) {
            Direction direction = (Direction)this.directions.get(i);
            if (!relDirection.matches(direction)) continue;
            all[index++] = transactionState.getAddedRelationships(relDirection, this.types.get(i));
        }
        if (index != this.types.size()) {
            all = Arrays.copyOf(all, index);
        }
        return PrimitiveLongCollections.concat((LongIterator[])all);
    }

    private LongIterator addedRelationshipsInner(NodeState transactionState) {
        LongIterator[] all = new LongIterator[this.types.size()];
        int index = 0;
        for (int i = 0; i < this.types.size(); ++i) {
            all[index++] = transactionState.getAddedRelationships((Direction)this.directions.get(i), this.types.get(i));
        }
        if (index != this.types.size()) {
            all = Arrays.copyOf(all, index);
        }
        return PrimitiveLongCollections.concat((LongIterator[])all);
    }

    public LongIterator addedRelationships(NodeState transactionState) {
        return switch (this.untyped) {
            default -> throw new IncompatibleClassChangeError();
            case DirectionCombination.Outgoing -> PrimitiveLongCollections.concat((LongIterator[])new LongIterator[]{transactionState.getAddedRelationships(Direction.OUTGOING), this.addedRelationshipsInner(transactionState, RelationshipDirection.INCOMING)});
            case DirectionCombination.Incoming -> PrimitiveLongCollections.concat((LongIterator[])new LongIterator[]{transactionState.getAddedRelationships(Direction.INCOMING), this.addedRelationshipsInner(transactionState, RelationshipDirection.OUTGOING)});
            case DirectionCombination.Both -> transactionState.getAddedRelationships();
            case DirectionCombination.Neither -> this.addedRelationshipsInner(transactionState);
        };
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.types.size(); ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(this.types.get(i)).append(":").append(this.directions.get(i));
        }
        if (this.untyped != DirectionCombination.Neither) {
            if (this.types.size() > 0) {
                builder.append(", ");
            }
            builder.append("*:").append(this.untyped.direction);
        }
        return builder.toString();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum DirectionCombination {
        Neither(null){

            @Override
            public Direction combine(Direction direction) {
                return direction;
            }
        }
        ,
        Outgoing(Direction.OUTGOING){

            @Override
            public Direction combine(Direction direction) {
                return direction == Direction.OUTGOING ? Direction.OUTGOING : Direction.BOTH;
            }
        }
        ,
        Incoming(Direction.INCOMING){

            @Override
            public Direction combine(Direction direction) {
                return direction == Direction.INCOMING ? Direction.INCOMING : Direction.BOTH;
            }
        }
        ,
        Both(Direction.BOTH){

            @Override
            public Direction combine(Direction direction) {
                return Direction.BOTH;
            }
        };

        private final Direction direction;

        private DirectionCombination(Direction direction) {
            this.direction = direction;
        }

        public boolean matchesDirection(Direction direction) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case Neither -> false;
                case Outgoing -> {
                    if (direction == Direction.OUTGOING) {
                        yield true;
                    }
                    yield false;
                }
                case Incoming -> {
                    if (direction == Direction.INCOMING) {
                        yield true;
                    }
                    yield false;
                }
                case Both -> true;
            };
        }

        public boolean matchesOutgoing() {
            return this == Outgoing || this == Both;
        }

        public boolean matchesIncoming() {
            return this == Incoming || this == Both;
        }

        public boolean matchesLoop() {
            return this != Neither;
        }

        private DirectionCombination fromDirection(Direction direction) {
            return switch (direction) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.OUTGOING -> Outgoing;
                case Direction.INCOMING -> Incoming;
                case Direction.BOTH -> Both;
            };
        }

        public int numberOfCriteria() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case Neither -> 0;
                case Outgoing, Incoming, Both -> 1;
            };
        }

        public DirectionCombination addDirection(Direction direction) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case Neither -> this.fromDirection(direction);
                case Outgoing -> {
                    if (direction == Direction.INCOMING || direction == Direction.BOTH) {
                        yield Both;
                    }
                    yield this;
                }
                case Incoming -> {
                    if (direction == Direction.OUTGOING || direction == Direction.BOTH) {
                        yield Both;
                    }
                    yield this;
                }
                case Both -> this;
            };
        }

        public DirectionCombination reverse() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case Neither -> Neither;
                case Outgoing -> Incoming;
                case Incoming -> Outgoing;
                case Both -> Both;
            };
        }

        public abstract Direction combine(Direction var1);
    }
}

