/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.TokenIndexEntryUpdate;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;

public interface IndexUpdater
extends AutoCloseable {
    public void process(IndexEntryUpdate<?> var1) throws IndexEntryConflictException;

    default public void yield() {
    }

    default public <INDEX_KEY extends SchemaDescriptorSupplier> ValueIndexEntryUpdate<INDEX_KEY> asValueUpdate(IndexEntryUpdate<INDEX_KEY> update) {
        if (update instanceof ValueIndexEntryUpdate) {
            return (ValueIndexEntryUpdate)update;
        }
        throw new UnsupportedOperationException("Tried to process " + update + " with " + this.getClass().getSimpleName() + ", but this is not supported.");
    }

    default public <INDEX_KEY extends SchemaDescriptorSupplier> TokenIndexEntryUpdate<INDEX_KEY> asTokenUpdate(IndexEntryUpdate<INDEX_KEY> update) {
        if (update instanceof TokenIndexEntryUpdate) {
            return (TokenIndexEntryUpdate)update;
        }
        throw new UnsupportedOperationException("Tried to process " + update + " with " + this.getClass().getSimpleName() + ", but this is not supported.");
    }

    @Override
    public void close() throws IndexEntryConflictException;
}

