/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.security;

import org.eclipse.collections.api.factory.primitive.IntObjectMaps;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.StoragePropertyCursor;
import org.neo4j.values.storable.Value;

public interface ReadSecurityPropertyProvider {
    public IntObjectMap<Value> getSecurityProperties();

    public static class LazyReadSecurityPropertyProvider
    implements ReadSecurityPropertyProvider {
        private final StoragePropertyCursor securityPropCursor;
        private MutableIntObjectMap<Value> properties;
        private final Iterable<StorageProperty> txStateChangedProperties;
        private final PropertySelection securityProperties;

        public LazyReadSecurityPropertyProvider(StoragePropertyCursor securityPropCursor, Iterable<StorageProperty> txStateChangedProperties, PropertySelection securityProperties) {
            this.securityPropCursor = securityPropCursor;
            this.txStateChangedProperties = txStateChangedProperties;
            this.securityProperties = securityProperties;
        }

        @Override
        public IntObjectMap<Value> getSecurityProperties() {
            if (this.properties == null) {
                this.properties = IntObjectMaps.mutable.empty();
                while (this.securityPropCursor.next()) {
                    this.properties.put(this.securityPropCursor.propertyKey(), (Object)this.securityPropCursor.propertyValue());
                }
                if (this.txStateChangedProperties != null) {
                    for (StorageProperty changedProperty : this.txStateChangedProperties) {
                        if (this.securityProperties != null) {
                            if (!this.securityProperties.test(changedProperty.propertyKeyId())) continue;
                            this.properties.put(changedProperty.propertyKeyId(), (Object)changedProperty.value());
                            continue;
                        }
                        this.properties.put(changedProperty.propertyKeyId(), (Object)changedProperty.value());
                    }
                }
            }
            return this.properties;
        }
    }
}

