/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.graphdb.Direction;

public interface Degrees {
    public static final Degrees EMPTY = new Degrees(){
        private final int[] noTypes = ArrayUtils.EMPTY_INT_ARRAY;

        @Override
        public int[] types() {
            return this.noTypes;
        }

        @Override
        public int degree(int type, Direction direction) {
            return 0;
        }
    };

    public int[] types();

    public int degree(int var1, Direction var2);

    default public int outgoingDegree(int type) {
        return this.degree(type, Direction.OUTGOING);
    }

    default public int incomingDegree(int type) {
        return this.degree(type, Direction.INCOMING);
    }

    default public int totalDegree(int type) {
        return this.degree(type, Direction.BOTH);
    }

    default public int degree(Direction direction) {
        switch (direction) {
            case OUTGOING: {
                return this.outgoingDegree();
            }
            case INCOMING: {
                return this.incomingDegree();
            }
            case BOTH: {
                return this.totalDegree();
            }
        }
        throw new UnsupportedOperationException("Unknown direction " + direction);
    }

    default public int outgoingDegree() {
        int degree = 0;
        for (int type : this.types()) {
            degree += this.outgoingDegree(type);
        }
        return degree;
    }

    default public int incomingDegree() {
        int degree = 0;
        for (int type : this.types()) {
            degree += this.incomingDegree(type);
        }
        return degree;
    }

    default public int totalDegree() {
        int degree = 0;
        for (int type : this.types()) {
            degree += this.totalDegree(type);
        }
        return degree;
    }

    public static interface Mutator {
        public boolean add(int var1, int var2, int var3, int var4);

        public boolean isSplit();
    }
}

