/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.security;

import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.internal.kernel.api.security.PropertyRule;
import org.neo4j.internal.kernel.api.security.Segment;
import org.neo4j.util.Preconditions;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public interface PatternSegment
extends Segment {
    public static final Set<String> ALL_LABELS = Set.of();

    default public String labelsString() {
        return this.labels().isEmpty() ? "" : this.labels().stream().sorted().collect(Collectors.joining("|", ":", ""));
    }

    default public String nodeString() {
        return String.format("(n%s)", this.labelsString());
    }

    default public String propertyString() {
        return String.format("n.%s", this.property());
    }

    public Set<String> labels();

    public String property();

    @Override
    default public boolean satisfies(Segment segment) {
        throw new UnsupportedOperationException();
    }

    public record NullPatternSegment(Set<String> labels, String property, PropertyRule.NullOperator operator) implements PatternSegment
    {
        public NullPatternSegment(String property, PropertyRule.NullOperator operator) {
            this(ALL_LABELS, property, operator);
        }

        public NullPatternSegment {
            Preconditions.requireNonNull(labels, (String)"labels must not be null");
            Preconditions.requireNonNull((Object)property, (String)"property must not be null");
        }

        @Override
        public String toString() {
            return String.format("FOR %s WHERE %s %s", this.nodeString(), this.propertyString(), this.operator.getSymbol());
        }
    }

    public record ValuePatternSegment(Set<String> labels, String property, Value value, PropertyRule.ComparisonOperator operator) implements PatternSegment
    {
        public ValuePatternSegment(String property, Value value, PropertyRule.ComparisonOperator operator) {
            this(ALL_LABELS, property, value, operator);
        }

        public ValuePatternSegment {
            Preconditions.requireNonNull(labels, (String)"labels must not be null");
            Preconditions.requireNonNull((Object)property, (String)"property must not be null");
            Preconditions.requireNonNull((Object)value, (String)"value must not be null");
            Preconditions.checkArgument((value != Values.NO_VALUE ? 1 : 0) != 0, (String)"value must not be NO_VALUE. Use NullPatternSegment for this purpose.");
        }

        @Override
        public String toString() {
            return String.format("FOR %s WHERE %s %s %s", this.nodeString(), this.propertyString(), this.operator.getSymbol(), this.value.prettyPrint());
        }
    }
}

