/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.security;

import org.neo4j.internal.kernel.api.security.Segment;

public class LoadSegment
implements Segment {
    private final String cidr;
    private final String url;
    public static LoadSegment ALL = new LoadSegment(null, null);

    private LoadSegment(String cidr, String url) {
        this.cidr = cidr;
        this.url = url;
    }

    @Override
    public boolean satisfies(Segment segment) {
        if (segment instanceof LoadSegment) {
            LoadSegment other = (LoadSegment)segment;
            return !(this.cidr != null && !this.cidr.equals(other.cidr) || this.url != null && !this.url.equals(other.url));
        }
        return false;
    }

    public static LoadSegment CIDR(String cidr) {
        return new LoadSegment(cidr, null);
    }

    public static LoadSegment URL(String url) {
        return new LoadSegment(null, url);
    }

    public static LoadSegment fromValueString(String value) {
        if (value.equals("ALL DATA")) {
            return ALL;
        }
        if (value.startsWith("CIDR")) {
            String[] splitValue = value.split("'");
            return LoadSegment.CIDR(splitValue[1]);
        }
        String[] splitValue = value.split("'");
        return LoadSegment.URL(splitValue[1]);
    }

    public boolean isCidr() {
        return this.cidr != null;
    }

    public boolean isUrl() {
        return this.url != null;
    }

    public String getCidr() {
        return this.cidr;
    }

    public String getUrl() {
        return this.url;
    }

    public String toString() {
        if (this.cidr == null && this.url == null) {
            return "ALL DATA";
        }
        if (this.cidr == null) {
            return String.format("URL \"%s\"", this.url);
        }
        return String.format("CIDR \"%s\"", this.cidr);
    }

    public String toValue() {
        if (this.cidr == null && this.url == null) {
            return "ALL DATA";
        }
        if (this.cidr == null) {
            return String.format("URL('%s')", this.url);
        }
        return String.format("CIDR('%s')", this.cidr);
    }
}

