/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.security;

import java.util.Objects;
import java.util.function.Predicate;
import org.neo4j.values.storable.Value;

public interface PropertyRule
extends Predicate<Value> {
    public static PropertyRule newRule(int propertyKey, Value value, boolean equals) {
        return new PropertyValueRule(propertyKey, value, equals);
    }

    public int property();

    public record PropertyValueRule(int property, Value value, boolean equals) implements PropertyRule
    {
        public PropertyValueRule {
            Objects.requireNonNull(value, "value must not be null");
        }

        @Override
        public boolean test(Value value) {
            return this.equals == this.value.equals(value);
        }
    }
}

