/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

import java.io.Serializable;
import org.apache.commons.lang3.mutable.MutableLong;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.primitive.LongToLongFunction;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.LongLongProcedure;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.impl.map.mutable.UnifiedMap;
import org.eclipse.collections.impl.map.mutable.primitive.LongLongHashMap;

public class CountsDelta {
    private static final long DEFAULT_COUNT = 0L;
    protected final LongLongHashMap nodeCounts = new LongLongHashMap();
    protected final MutableMap<RelationshipKey, MutableLong> relationshipCounts = UnifiedMap.newMap();

    public long nodeCount(int labelId) {
        return this.nodeCounts.getIfAbsent((long)labelId, 0L);
    }

    public void incrementNodeCount(long labelId, long delta) {
        if (delta != 0L) {
            this.nodeCounts.updateValue(labelId, 0L, (LongToLongFunction & Serializable)l -> l + delta);
        }
    }

    public long relationshipCount(int startLabelId, int typeId, int endLabelId) {
        RelationshipKey relationshipKey = new RelationshipKey(startLabelId, typeId, endLabelId);
        MutableLong counts = (MutableLong)this.relationshipCounts.get((Object)relationshipKey);
        return counts == null ? 0L : counts.longValue();
    }

    public void incrementRelationshipCount(long startLabelId, int typeId, long endLabelId, long delta) {
        if (delta != 0L) {
            RelationshipKey relationshipKey = new RelationshipKey(Math.toIntExact(startLabelId), typeId, Math.toIntExact(endLabelId));
            ((MutableLong)this.relationshipCounts.getIfAbsentPutWithKey((Object)relationshipKey, (Function & Serializable)k -> new MutableLong(0L))).add(delta);
        }
    }

    public void accept(Visitor visitor) {
        this.nodeCounts.forEachKeyValue((LongLongProcedure & Serializable)(id, count) -> visitor.visitNodeCount(Math.toIntExact(id), count));
        this.relationshipCounts.forEachKeyValue((Procedure2 & Serializable)(k, count) -> visitor.visitRelationshipCount(k.startLabelId, k.typeId, k.endLabelId, count.longValue()));
    }

    public boolean hasChanges() {
        return !this.nodeCounts.isEmpty() || !this.relationshipCounts.isEmpty();
    }

    public record RelationshipKey(int startLabelId, int typeId, int endLabelId) {
    }

    public static interface Visitor {
        public void visitNodeCount(int var1, long var2);

        public void visitRelationshipCount(int var1, int var2, int var3, long var4);
    }
}

