/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public final class IndexQueryHelper {
    private IndexQueryHelper() {
    }

    public static PropertyIndexQuery exact(int propertyKeyId, Object value) {
        return IndexQueryHelper.exact(propertyKeyId, Values.of((Object)value));
    }

    public static PropertyIndexQuery exact(int propertyKeyId, Value value) {
        return PropertyIndexQuery.exact(propertyKeyId, value);
    }

    public static ValueIndexEntryUpdate<SchemaDescriptor> add(long nodeId, SchemaDescriptor schema, Object ... objects) {
        return IndexEntryUpdate.add((long)nodeId, (SchemaDescriptorSupplier)schema, (Value[])IndexQueryHelper.toValues(objects));
    }

    public static ValueIndexEntryUpdate<SchemaDescriptor> remove(long nodeId, SchemaDescriptor schema, Object ... objects) {
        return IndexEntryUpdate.remove((long)nodeId, (SchemaDescriptorSupplier)schema, (Value[])IndexQueryHelper.toValues(objects));
    }

    public static ValueIndexEntryUpdate<SchemaDescriptor> change(long nodeId, SchemaDescriptor schema, Object o1, Object o2) {
        return IndexEntryUpdate.change((long)nodeId, (SchemaDescriptorSupplier)schema, (Value)Values.of((Object)o1), (Value)Values.of((Object)o2));
    }

    public static ValueIndexEntryUpdate<SchemaDescriptor> change(long nodeId, SchemaDescriptor schema, Object[] o1, Object[] o2) {
        return IndexEntryUpdate.change((long)nodeId, (SchemaDescriptorSupplier)schema, (Value[])IndexQueryHelper.toValues(o1), (Value[])IndexQueryHelper.toValues(o2));
    }

    private static Value[] toValues(Object[] objects) {
        Value[] values = new Value[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            Object object = objects[i];
            values[i] = object instanceof Value ? (Value)object : Values.of((Object)object);
        }
        return values;
    }
}

