/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.security;

import org.neo4j.internal.helpers.Strings;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.log4j.LogExtended;
import org.neo4j.logging.log4j.Neo4jLogMessage;
import org.neo4j.logging.log4j.StructureAwareMessage;

public abstract class AbstractSecurityLog
extends LifecycleAdapter {
    LogExtended inner;

    public void setLog(LogExtended inner) {
        this.inner = inner;
    }

    public void debug(String message) {
        this.inner.debug((Neo4jLogMessage)new SecurityLogLine(message));
    }

    public void debug(SecurityContext context, String message) {
        this.inner.debug((Neo4jLogMessage)new SecurityLogLine(context.connectionInfo(), context.database(), context.subject().username(), message));
    }

    public void info(String message) {
        this.inner.info((Neo4jLogMessage)new SecurityLogLine(message));
    }

    public void info(LoginContext loginContext, String message) {
        this.inner.info((Neo4jLogMessage)new SecurityLogLine(loginContext.connectionInfo(), null, loginContext.subject().username(), message));
    }

    public void info(SecurityContext context, String message) {
        this.inner.info((Neo4jLogMessage)new SecurityLogLine(context.connectionInfo(), context.database(), context.subject().username(), message));
    }

    public void warn(String message) {
        this.inner.warn((Neo4jLogMessage)new SecurityLogLine(message));
    }

    public void warn(SecurityContext context, String message) {
        this.inner.warn((Neo4jLogMessage)new SecurityLogLine(context.connectionInfo(), context.database(), context.subject().username(), message));
    }

    public void error(String message) {
        this.inner.error((Neo4jLogMessage)new SecurityLogLine(message));
    }

    public void error(ClientConnectionInfo connectionInfo, String message) {
        this.inner.error((Neo4jLogMessage)new SecurityLogLine(connectionInfo, null, null, message));
    }

    public void error(LoginContext context, String message) {
        this.inner.error((Neo4jLogMessage)new SecurityLogLine(context.connectionInfo(), null, context.subject().username(), message));
    }

    public void error(LoginContext context, String database, String message) {
        this.inner.error((Neo4jLogMessage)new SecurityLogLine(context.connectionInfo(), database, context.subject().username(), message));
    }

    public void error(SecurityContext context, String message) {
        this.inner.error((Neo4jLogMessage)new SecurityLogLine(context.connectionInfo(), context.database(), context.subject().username(), message));
    }

    public boolean isDebugEnabled() {
        return this.inner.isDebugEnabled();
    }

    static class SecurityLogLine
    extends StructureAwareMessage {
        private final String username;
        private final String sourceString;
        private final String message;
        private final String database;

        SecurityLogLine(String message) {
            this.sourceString = null;
            this.database = null;
            this.username = null;
            this.message = message;
        }

        SecurityLogLine(ClientConnectionInfo connectionInfo, String database, String username, String message) {
            this.sourceString = connectionInfo.asConnectionDetails();
            this.database = database;
            this.username = username;
            this.message = message.replaceAll("\\R+", " ");
        }

        public void asString(StringBuilder sb) {
            if (this.username != null && this.username.length() > 0) {
                sb.append("[").append(Strings.escape((String)this.username)).append("]: ");
            }
            sb.append(this.message);
        }

        public void asStructure(StructureAwareMessage.FieldConsumer fieldConsumer) {
            fieldConsumer.add("type", "security");
            fieldConsumer.add("source", this.sourceString);
            if (this.database != null) {
                fieldConsumer.add("database", this.database);
            }
            if (this.username != null && this.username.length() > 0) {
                fieldConsumer.add("username", this.username);
            }
            fieldConsumer.add("message", this.message);
        }
    }
}

