/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api;

import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;

public final class NumberRangePredicate
extends IndexQuery.RangePredicate<NumberValue> {
    private NumberRangePredicate(int propertyKeyId, NumberValue from, boolean fromInclusive, NumberValue to, boolean toInclusive) {
        super(propertyKeyId, ValueGroup.NUMBER, from, fromInclusive, to, toInclusive);
    }

    static NumberRangePredicate create(int propertyKeyId, NumberValue from, boolean fromInclusive, NumberValue to, boolean toInclusive) {
        if (to == null) {
            to = Values.doubleValue((double)Double.POSITIVE_INFINITY);
            toInclusive = true;
        }
        return new NumberRangePredicate(propertyKeyId, from, fromInclusive, to, toInclusive);
    }

    public Number from() {
        return this.from == null ? (Number)null : (Number)((NumberValue)this.from).asObject();
    }

    public Number to() {
        return this.to == null ? (Number)null : (Number)((NumberValue)this.to).asObject();
    }
}

