/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.security;

import org.neo4j.internal.kernel.api.security.PrivilegeAction;

public class AdminActionOnResource {
    private final PrivilegeAction action;
    private final DatabaseScope resource;
    public static AdminActionOnResource ALL = new AdminActionOnResource(PrivilegeAction.ADMIN, DatabaseScope.ALL);

    public AdminActionOnResource(PrivilegeAction action, DatabaseScope resource) {
        this.action = action;
        this.resource = resource;
    }

    public boolean matches(AdminActionOnResource request) {
        return this.action.satisfies(request.action) && (this.resource.all || this.resource.name.equals(request.resource.name));
    }

    public static class DatabaseScope {
        private final String name;
        private final boolean all;
        public static final DatabaseScope ALL = new DatabaseScope("*", true);

        public DatabaseScope(String name) {
            this(name, false);
        }

        private DatabaseScope(String name, boolean all) {
            this.name = name;
            this.all = all;
        }
    }
}

