/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.io.File;
import java.util.StringJoiner;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.neo4j.internal.helpers.Format;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.logging.Log;

public class LoggingMonitor
implements IndexProvider.Monitor {
    private final Log log;

    public LoggingMonitor(Log log) {
        this.log = log;
    }

    @Override
    public void failedToOpenIndex(IndexDescriptor descriptor, String action, Exception cause) {
        if (this.log.isDebugEnabled()) {
            this.log.warn("Failed to open index:" + descriptor.getId() + ". " + action, (Throwable)cause);
        } else {
            this.log.warn("Failed to open index:" + descriptor.getId() + ". " + action + " Cause: " + cause.getMessage());
        }
    }

    @Override
    public void recoveryCleanupRegistered(File indexFile, IndexDescriptor index) {
        this.log.info("Schema index cleanup job registered: " + LoggingMonitor.indexDescription(indexFile, index));
    }

    @Override
    public void recoveryCleanupStarted(File indexFile, IndexDescriptor index) {
        this.log.info("Schema index cleanup job started: " + LoggingMonitor.indexDescription(indexFile, index));
    }

    @Override
    public void recoveryCleanupFinished(File indexFile, IndexDescriptor index, long numberOfPagesVisited, long numberOfTreeNodes, long numberOfCleanedCrashPointers, long durationMillis) {
        StringJoiner joiner = new StringJoiner(", ", "Schema index cleanup job finished: " + LoggingMonitor.indexDescription(indexFile, index) + " ", "");
        joiner.add("Number of pages visited: " + numberOfPagesVisited);
        joiner.add("Number of tree nodes: " + numberOfTreeNodes);
        joiner.add("Number of cleaned crashed pointers: " + numberOfCleanedCrashPointers);
        joiner.add("Time spent: " + Format.duration((long)durationMillis));
        this.log.info(joiner.toString());
    }

    @Override
    public void recoveryCleanupClosed(File indexFile, IndexDescriptor index) {
        this.log.info("Schema index cleanup job closed: " + LoggingMonitor.indexDescription(indexFile, index));
    }

    @Override
    public void recoveryCleanupFailed(File indexFile, IndexDescriptor index, Throwable throwable) {
        this.log.info(String.format("Schema index cleanup job failed: %s.%nCaused by: %s", LoggingMonitor.indexDescription(indexFile, index), ExceptionUtils.getStackTrace((Throwable)throwable)));
    }

    private static String indexDescription(File indexFile, IndexDescriptor indexDescriptor) {
        return "descriptor=" + indexDescriptor.toString() + ", indexFile=" + indexFile.getAbsolutePath();
    }
}

