/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers;

import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.RelationshipGroupCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.security.AccessMode;

public final class Nodes {
    private Nodes() {
        throw new UnsupportedOperationException("Do not instantiate");
    }

    public static int countOutgoing(NodeCursor nodeCursor, CursorFactory cursors, AccessMode mode) {
        if (nodeCursor.isDense() && mode.allowsTraverseAllLabels() && mode.allowsTraverseAllRelTypes()) {
            try (RelationshipGroupCursor group = cursors.allocateRelationshipGroupCursor();){
                nodeCursor.relationships(group);
                int count = 0;
                while (group.next()) {
                    count += group.outgoingCount() + group.loopCount();
                }
                int n = count;
                return n;
            }
        }
        try (RelationshipTraversalCursor traversal = cursors.allocateRelationshipTraversalCursor();){
            int count = 0;
            nodeCursor.allRelationships(traversal);
            while (traversal.next()) {
                if (traversal.sourceNodeReference() != nodeCursor.nodeReference()) continue;
                ++count;
            }
            int n = count;
            return n;
        }
    }

    public static int countIncoming(NodeCursor nodeCursor, CursorFactory cursors, AccessMode mode) {
        if (nodeCursor.isDense() && mode.allowsTraverseAllLabels() && mode.allowsTraverseAllRelTypes()) {
            try (RelationshipGroupCursor group = cursors.allocateRelationshipGroupCursor();){
                nodeCursor.relationships(group);
                int count = 0;
                while (group.next()) {
                    count += group.incomingCount() + group.loopCount();
                }
                int n = count;
                return n;
            }
        }
        try (RelationshipTraversalCursor traversal = cursors.allocateRelationshipTraversalCursor();){
            int count = 0;
            nodeCursor.allRelationships(traversal);
            while (traversal.next()) {
                if (traversal.targetNodeReference() != nodeCursor.nodeReference()) continue;
                ++count;
            }
            int n = count;
            return n;
        }
    }

    public static int countAll(NodeCursor nodeCursor, CursorFactory cursors, AccessMode mode) {
        if (nodeCursor.isDense() && mode.allowsTraverseAllLabels() && mode.allowsTraverseAllRelTypes()) {
            try (RelationshipGroupCursor group = cursors.allocateRelationshipGroupCursor();){
                nodeCursor.relationships(group);
                int count = 0;
                while (group.next()) {
                    count += group.totalCount();
                }
                int n = count;
                return n;
            }
        }
        try (RelationshipTraversalCursor traversal = cursors.allocateRelationshipTraversalCursor();){
            int count = 0;
            nodeCursor.allRelationships(traversal);
            while (traversal.next()) {
                ++count;
            }
            int n = count;
            return n;
        }
    }

    public static int countOutgoing(NodeCursor nodeCursor, CursorFactory cursors, int type, AccessMode mode) {
        if (nodeCursor.isDense() && mode.allowsTraverseAllLabels() && mode.allowsTraverseRelType(type)) {
            try (RelationshipGroupCursor group = cursors.allocateRelationshipGroupCursor();){
                nodeCursor.relationships(group);
                while (group.next()) {
                    if (group.type() != type) continue;
                    int n = group.outgoingCount() + group.loopCount();
                    return n;
                }
                int n = 0;
                return n;
            }
        }
        try (RelationshipTraversalCursor traversal = cursors.allocateRelationshipTraversalCursor();){
            int count = 0;
            nodeCursor.allRelationships(traversal);
            while (traversal.next()) {
                if (traversal.sourceNodeReference() != nodeCursor.nodeReference() || traversal.type() != type) continue;
                ++count;
            }
            int n = count;
            return n;
        }
    }

    public static int countIncoming(NodeCursor nodeCursor, CursorFactory cursors, int type, AccessMode mode) {
        if (nodeCursor.isDense() && mode.allowsTraverseAllLabels() && mode.allowsTraverseRelType(type)) {
            try (RelationshipGroupCursor group = cursors.allocateRelationshipGroupCursor();){
                nodeCursor.relationships(group);
                int count = 0;
                while (group.next()) {
                    if (group.type() != type) continue;
                    int n = group.incomingCount() + group.loopCount();
                    return n;
                }
                int n = count;
                return n;
            }
        }
        try (RelationshipTraversalCursor traversal = cursors.allocateRelationshipTraversalCursor();){
            int count = 0;
            nodeCursor.allRelationships(traversal);
            while (traversal.next()) {
                if (traversal.targetNodeReference() != nodeCursor.nodeReference() || traversal.type() != type) continue;
                ++count;
            }
            int n = count;
            return n;
        }
    }

    public static int countAll(NodeCursor nodeCursor, CursorFactory cursors, int type, AccessMode mode) {
        if (nodeCursor.isDense() && mode.allowsTraverseAllLabels() && mode.allowsTraverseRelType(type)) {
            try (RelationshipGroupCursor group = cursors.allocateRelationshipGroupCursor();){
                nodeCursor.relationships(group);
                int count = 0;
                while (group.next()) {
                    if (group.type() != type) continue;
                    int n = group.totalCount();
                    return n;
                }
                int n = count;
                return n;
            }
        }
        try (RelationshipTraversalCursor traversal = cursors.allocateRelationshipTraversalCursor();){
            int count = 0;
            nodeCursor.allRelationships(traversal);
            while (traversal.next()) {
                if (traversal.type() != type) continue;
                ++count;
            }
            int n = count;
            return n;
        }
    }
}

