/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.ExecutionStatistics;
import org.neo4j.internal.kernel.api.Locks;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Procedures;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.SchemaWrite;
import org.neo4j.internal.kernel.api.Token;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.internal.kernel.api.exceptions.LocksNotFrozenException;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.ClockContext;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;

public interface KernelTransaction
extends AssertOpen,
AutoCloseable {
    public static final long ROLLBACK = -1L;
    public static final long READ_ONLY = 0L;

    public long commit() throws TransactionFailureException;

    public void rollback() throws TransactionFailureException;

    public Read dataRead();

    public Write dataWrite() throws InvalidTransactionTypeKernelException;

    public TokenRead tokenRead();

    public TokenWrite tokenWrite();

    public Token token();

    public SchemaRead schemaRead();

    public SchemaWrite schemaWrite() throws InvalidTransactionTypeKernelException;

    public Locks locks();

    public void freezeLocks();

    public void thawLocks() throws LocksNotFrozenException;

    public CursorFactory cursors();

    public Procedures procedures();

    public ExecutionStatistics executionStatistics();

    public long closeTransaction() throws TransactionFailureException;

    @Override
    default public void close() throws TransactionFailureException {
        if (this.isOpen()) {
            this.closeTransaction();
        }
    }

    public boolean isOpen();

    public boolean isClosing();

    public Optional<Status> getReasonIfTerminated();

    public boolean isTerminated();

    public void markForTermination(Status var1);

    public void setMetaData(Map<String, Object> var1);

    public Map<String, Object> getMetaData();

    public Statement acquireStatement();

    public IndexDescriptor indexUniqueCreate(IndexPrototype var1) throws KernelException;

    public SecurityContext securityContext();

    public ClientConnectionInfo clientInfo();

    public AuthSubject subjectOrAnonymous();

    public long lastTransactionTimestampWhenStarted();

    public long lastTransactionIdWhenStarted();

    public void bindToUserTransaction(InternalTransaction var1);

    public InternalTransaction internalTransaction();

    public long startTime();

    public long startTimeNanos();

    public long timeout();

    public Type transactionType();

    public long getTransactionId();

    public long getCommitTime();

    public Revertable overrideWith(SecurityContext var1);

    public ClockContext clocks();

    public NodeCursor ambientNodeCursor();

    public RelationshipScanCursor ambientRelationshipCursor();

    public PropertyCursor ambientPropertyCursor();

    public boolean isSchemaTransaction();

    public PageCursorTracer pageCursorTracer();

    public UUID getDatabaseId();

    public String getDatabaseName();

    @FunctionalInterface
    public static interface Revertable
    extends AutoCloseable {
        @Override
        public void close();
    }

    public static enum Type {
        implicit,
        explicit;

    }
}

