/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers;

import org.neo4j.internal.kernel.api.CloseListener;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.helpers.RelationshipSelectionCursor;
import org.neo4j.internal.kernel.api.helpers.RelationshipSparseSelection;

public final class RelationshipSparseSelectionCursor
extends RelationshipSparseSelection
implements RelationshipSelectionCursor {
    @Override
    public boolean next() {
        if (!this.fetchNext()) {
            this.close();
            return false;
        }
        return true;
    }

    @Override
    public void close() {
        this.closeInternal();
        CloseListener listener = this.closeListener;
        if (listener != null) {
            listener.onClosed(this);
        }
    }

    @Override
    public long relationshipReference() {
        return this.cursor.relationshipReference();
    }

    @Override
    public int type() {
        return this.cursor.type();
    }

    @Override
    public long otherNodeReference() {
        return this.cursor.originNodeReference() == this.cursor.sourceNodeReference() ? this.cursor.targetNodeReference() : this.cursor.sourceNodeReference();
    }

    @Override
    public long sourceNodeReference() {
        return this.cursor.sourceNodeReference();
    }

    @Override
    public long targetNodeReference() {
        return this.cursor.targetNodeReference();
    }

    @Override
    public long propertiesReference() {
        return this.cursor.propertiesReference();
    }

    @Override
    public boolean isClosed() {
        return this.cursor == null || this.cursor.isClosed();
    }

    @Override
    public void setTracer(KernelReadTracer tracer) {
        this.cursor.setTracer(tracer);
    }

    public String toString() {
        if (this.isClosed()) {
            return "RelationshipSparseSelectionCursor[closed state]";
        }
        return "RelationshipSparseSelectionCursor[cursor=" + this.cursor.toString() + "]";
    }

    public RelationshipTraversalCursor traversalCursor() {
        return this.cursor;
    }
}

