/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.schema;

import java.util.function.Predicate;
import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.internal.kernel.api.schema.SchemaComputer;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.kernel.api.schema.SchemaProcessor;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.storageengine.api.lock.ResourceType;

public interface SchemaDescriptor
extends SchemaDescriptorSupplier {
    public static final SchemaDescriptor NO_SCHEMA = new SchemaDescriptor(){

        @Override
        public boolean isAffected(long[] entityIds) {
            return false;
        }

        @Override
        public <R> R computeWith(SchemaComputer<R> computer) {
            return null;
        }

        @Override
        public void processWith(SchemaProcessor processor) {
        }

        @Override
        public String userDescription(TokenNameLookup tokenNameLookup) {
            return "NO_SCHEMA";
        }

        @Override
        public int[] getPropertyIds() {
            return new int[0];
        }

        @Override
        public int[] getEntityTokenIds() {
            return new int[0];
        }

        @Override
        public int keyId() {
            return 0;
        }

        @Override
        public ResourceType keyType() {
            return null;
        }

        @Override
        public EntityType entityType() {
            return null;
        }

        @Override
        public PropertySchemaType propertySchemaType() {
            return null;
        }

        @Override
        public SchemaDescriptor schema() {
            return null;
        }
    };

    public static long[] schemaTokenLockingIds(SchemaDescriptor schema) {
        return SchemaDescriptor.schemaTokenLockingIds(schema.getEntityTokenIds());
    }

    public static long[] schemaTokenLockingIds(int[] tokenIds) {
        long[] lockingIds = new long[tokenIds.length];
        for (int i = 0; i < lockingIds.length; ++i) {
            lockingIds[i] = tokenIds[i];
        }
        return lockingIds;
    }

    public boolean isAffected(long[] var1);

    public <R> R computeWith(SchemaComputer<R> var1);

    public void processWith(SchemaProcessor var1);

    public String userDescription(TokenNameLookup var1);

    public int[] getPropertyIds();

    default public int getPropertyId() {
        int[] propertyIds = this.getPropertyIds();
        if (propertyIds.length != 1) {
            throw new IllegalStateException("Single property schema requires one property but had " + propertyIds.length);
        }
        return propertyIds[0];
    }

    public int[] getEntityTokenIds();

    public int keyId();

    public ResourceType keyType();

    public EntityType entityType();

    public PropertySchemaType propertySchemaType();

    public static <T extends SchemaDescriptorSupplier> Predicate<T> equalTo(SchemaDescriptor descriptor) {
        return supplier -> descriptor.equals(supplier.schema());
    }

    public static enum PropertySchemaType {
        COMPLETE_ALL_TOKENS,
        PARTIAL_ANY_TOKEN;

    }
}

