/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.schema;

public class IndexProviderDescriptor {
    public static final IndexProviderDescriptor UNDECIDED = new IndexProviderDescriptor("Undecided", "0");
    private final String key;
    private final String version;

    public IndexProviderDescriptor(String key, String version) {
        if (key == null) {
            throw new IllegalArgumentException("null provider key prohibited");
        }
        if (key.length() == 0) {
            throw new IllegalArgumentException("empty provider key prohibited");
        }
        if (version == null) {
            throw new IllegalArgumentException("null provider version prohibited");
        }
        this.key = key;
        this.version = version;
    }

    public String getKey() {
        return this.key;
    }

    public String getVersion() {
        return this.version;
    }

    public String name() {
        return this.key + "-" + this.version;
    }

    public int hashCode() {
        return 23 + this.key.hashCode() ^ this.version.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof IndexProviderDescriptor) {
            IndexProviderDescriptor otherDescriptor = (IndexProviderDescriptor)obj;
            return this.key.equals(otherDescriptor.getKey()) && this.version.equals(otherDescriptor.getVersion());
        }
        return false;
    }

    public String toString() {
        return "{key=" + this.key + ", version=" + this.version + "}";
    }
}

