/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.procs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.procedure.Mode;

public class ProcedureSignature {
    public static final List<FieldSignature> VOID = Collections.unmodifiableList(new ArrayList());
    private final QualifiedName name;
    private final List<FieldSignature> inputSignature;
    private final List<FieldSignature> outputSignature;
    private final Mode mode;
    private final String deprecated;
    private final String[] allowed;
    private final String description;
    private final String warning;
    private final boolean eager;
    private final boolean caseInsensitive;

    public ProcedureSignature(QualifiedName name, List<FieldSignature> inputSignature, List<FieldSignature> outputSignature, Mode mode, String deprecated, String[] allowed, String description, String warning, boolean eager, boolean caseInsensitive) {
        this.name = name;
        this.inputSignature = Collections.unmodifiableList(inputSignature);
        this.outputSignature = outputSignature == VOID ? outputSignature : Collections.unmodifiableList(outputSignature);
        this.mode = mode;
        this.deprecated = deprecated;
        this.allowed = allowed;
        this.description = description;
        this.warning = warning;
        this.eager = eager;
        this.caseInsensitive = caseInsensitive;
    }

    public QualifiedName name() {
        return this.name;
    }

    public Mode mode() {
        return this.mode;
    }

    public Optional<String> deprecated() {
        return Optional.ofNullable(this.deprecated);
    }

    public String[] allowed() {
        return this.allowed;
    }

    public boolean caseInsensitive() {
        return this.caseInsensitive;
    }

    public List<FieldSignature> inputSignature() {
        return this.inputSignature;
    }

    public List<FieldSignature> outputSignature() {
        return this.outputSignature;
    }

    public boolean isVoid() {
        return this.outputSignature == VOID;
    }

    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    public Optional<String> warning() {
        return Optional.ofNullable(this.warning);
    }

    public boolean eager() {
        return this.eager;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcedureSignature that = (ProcedureSignature)o;
        return this.name.equals(that.name) && this.inputSignature.equals(that.inputSignature) && this.outputSignature.equals(that.outputSignature) && this.isVoid() == that.isVoid();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        String strInSig;
        String string = strInSig = this.inputSignature == null ? "..." : Iterables.toString(this.inputSignature, (String)", ");
        if (this.isVoid()) {
            return String.format("%s(%s) :: VOID", this.name, strInSig);
        }
        String strOutSig = this.outputSignature == null ? "..." : Iterables.toString(this.outputSignature, (String)", ");
        return String.format("%s(%s) :: (%s)", this.name, strInSig, strOutSig);
    }

    public static Builder procedureSignature(String ... namespaceAndName) {
        String[] namespace = namespaceAndName.length > 1 ? Arrays.copyOf(namespaceAndName, namespaceAndName.length - 1) : new String[]{};
        String name = namespaceAndName[namespaceAndName.length - 1];
        return ProcedureSignature.procedureSignature(namespace, name);
    }

    public static Builder procedureSignature(QualifiedName name) {
        return new Builder(name.namespace(), name.name());
    }

    public static Builder procedureSignature(String[] namespace, String name) {
        return new Builder(namespace, name);
    }

    public static QualifiedName procedureName(String ... namespaceAndName) {
        return ProcedureSignature.procedureSignature(namespaceAndName).build().name();
    }

    public static class Builder {
        private final QualifiedName name;
        private final List<FieldSignature> inputSignature = new LinkedList<FieldSignature>();
        private List<FieldSignature> outputSignature = new LinkedList<FieldSignature>();
        private Mode mode = Mode.READ;
        private String deprecated;
        private String[] allowed = new String[0];
        private String description;
        private String warning;
        private boolean eager;

        public Builder(String[] namespace, String name) {
            this.name = new QualifiedName(namespace, name);
        }

        public Builder mode(Mode mode) {
            this.mode = mode;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder deprecatedBy(String deprecated) {
            this.deprecated = deprecated;
            return this;
        }

        public Builder in(String name, Neo4jTypes.AnyType type) {
            this.inputSignature.add(FieldSignature.inputField(name, type));
            return this;
        }

        public Builder out(String name, Neo4jTypes.AnyType type) {
            this.outputSignature.add(FieldSignature.outputField(name, type));
            return this;
        }

        public Builder out(List<FieldSignature> fields) {
            this.outputSignature = fields;
            return this;
        }

        public Builder allowed(String[] allowed) {
            this.allowed = allowed;
            return this;
        }

        public Builder warning(String warning) {
            this.warning = warning;
            return this;
        }

        public Builder eager(boolean eager) {
            this.eager = eager;
            return this;
        }

        public ProcedureSignature build() {
            return new ProcedureSignature(this.name, this.inputSignature, this.outputSignature, this.mode, this.deprecated, this.allowed, this.description, this.warning, this.eager, false);
        }
    }
}

