/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.EdgeGroupCursor;
import org.neo4j.internal.kernel.api.EdgeTraversalCursor;
import org.neo4j.internal.kernel.api.LabelSet;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.PropertyPredicate;

public abstract class NeighbourCursor
implements NodeCursor {
    private final NodeCursor neighbours;
    private final EdgeGroupCursor group;
    private final EdgeTraversalCursor edges;

    public static Builder outgoing(CursorFactory cursors, int label) {
        return new Builder(cursors).outgoing(label);
    }

    public static Builder outgoing(CursorFactory cursors, int label, PropertyPredicate edgeProperties) {
        return new Builder(cursors).outgoing(label, edgeProperties);
    }

    public static Builder incoming(CursorFactory cursors, int label) {
        return new Builder(cursors).incoming(label);
    }

    public static Builder incoming(CursorFactory cursors, int label, PropertyPredicate edgeProperties) {
        return new Builder(cursors).incoming(label, edgeProperties);
    }

    public static Builder any(CursorFactory cursors, int label) {
        return new Builder(cursors).any(label);
    }

    public static Builder any(CursorFactory cursors, int label, PropertyPredicate edgeProperties) {
        return new Builder(cursors).any(label, edgeProperties);
    }

    public static NeighbourCursor outgoing(CursorFactory cursors) {
        return new AnyLabel(cursors, true, false);
    }

    public static NeighbourCursor outgoing(CursorFactory cursors, PropertyPredicate edgeProperties) {
        Objects.requireNonNull(edgeProperties, "Edge PropertyPredicate");
        return new FilteringAnyLabel(cursors, true, false, edgeProperties);
    }

    public static NeighbourCursor incoming(CursorFactory cursors) {
        return new AnyLabel(cursors, false, true);
    }

    public static NeighbourCursor incoming(CursorFactory cursors, PropertyPredicate edgeProperties) {
        Objects.requireNonNull(edgeProperties, "Edge PropertyPredicate");
        return new FilteringAnyLabel(cursors, false, true, edgeProperties);
    }

    public static NeighbourCursor any(CursorFactory cursors) {
        return new AnyLabel(cursors, true, true);
    }

    public static NeighbourCursor any(CursorFactory cursors, PropertyPredicate edgeProperties) {
        Objects.requireNonNull(edgeProperties, "Edge PropertyPredicate");
        return new FilteringAnyLabel(cursors, true, true, edgeProperties);
    }

    public NeighbourCursor(CursorFactory cursors) {
        this.neighbours = cursors.allocateNodeCursor();
        this.group = cursors.allocateEdgeGroupCursor();
        this.edges = cursors.allocateEdgeTraversalCursor();
    }

    public final void of(NodeCursor node) {
        node.edges(this.group);
        this.group.close();
        this.edges.close();
    }

    @Override
    public final boolean next() {
        while (!this.edges.next()) {
            if (this.next(this.group, this.edges)) continue;
            return false;
        }
        do {
            this.edges.neighbour(this.neighbours);
        } while (this.edges.shouldRetry());
        return this.neighbours.next();
    }

    protected abstract boolean next(EdgeGroupCursor var1, EdgeTraversalCursor var2);

    @Override
    public final boolean shouldRetry() {
        return this.neighbours.shouldRetry();
    }

    @Override
    public final void close() {
        this.neighbours.close();
        this.group.close();
        this.edges.close();
    }

    @Override
    public final long nodeReference() {
        return this.neighbours.nodeReference();
    }

    @Override
    public final LabelSet labels() {
        return this.neighbours.labels();
    }

    @Override
    public final boolean hasProperties() {
        return this.neighbours.hasProperties();
    }

    @Override
    public final void edges(EdgeGroupCursor cursor) {
        this.neighbours.edges(cursor);
    }

    @Override
    public void outgoingEdges(EdgeGroupCursor groups, EdgeTraversalCursor edges) {
        this.neighbours.outgoingEdges(groups, edges);
    }

    @Override
    public void incomingEdges(EdgeGroupCursor groups, EdgeTraversalCursor edges) {
        this.neighbours.incomingEdges(groups, edges);
    }

    @Override
    public void allEdges(EdgeGroupCursor groups, EdgeTraversalCursor edges) {
        this.neighbours.allEdges(groups, edges);
    }

    @Override
    public final void properties(PropertyCursor cursor) {
        this.neighbours.properties(cursor);
    }

    @Override
    public final long edgeGroupReference() {
        return this.neighbours.edgeGroupReference();
    }

    @Override
    public final long propertiesReference() {
        return this.neighbours.propertiesReference();
    }

    private static final class FilteringExplicitLabels
    extends NeighbourCursor {
        private final PropertyCursor properties;

        FilteringExplicitLabels(CursorFactory cursors, Builder.Entry[] spec) {
            super(cursors);
            this.properties = cursors.allocatePropertyCursor();
        }

        @Override
        protected boolean next(EdgeGroupCursor group, EdgeTraversalCursor edges) {
            throw new UnsupportedOperationException("not implemented");
        }
    }

    private static final class ExplicitLabels
    extends NeighbourCursor {
        ExplicitLabels(CursorFactory cursors, Builder.Entry[] spec) {
            super(cursors);
        }

        @Override
        protected boolean next(EdgeGroupCursor group, EdgeTraversalCursor edges) {
            throw new UnsupportedOperationException("not implemented");
        }
    }

    private static final class FilteringAnyLabel
    extends NeighbourCursor {
        private final PropertyCursor properties;
        private final boolean outgoing;
        private final boolean incoming;
        private final PropertyPredicate predicate;

        FilteringAnyLabel(CursorFactory cursors, boolean outgoing, boolean incoming, PropertyPredicate predicate) {
            super(cursors);
            this.properties = cursors.allocatePropertyCursor();
            this.outgoing = outgoing;
            this.incoming = incoming;
            this.predicate = predicate;
        }

        @Override
        protected boolean next(EdgeGroupCursor group, EdgeTraversalCursor edges) {
            throw new UnsupportedOperationException("not implemented");
        }
    }

    private static final class AnyLabel
    extends NeighbourCursor {
        private final boolean outgoing;
        private final boolean incoming;

        AnyLabel(CursorFactory cursors, boolean outgoing, boolean incoming) {
            super(cursors);
            this.outgoing = outgoing;
            this.incoming = incoming;
        }

        @Override
        protected boolean next(EdgeGroupCursor group, EdgeTraversalCursor edges) {
            throw new UnsupportedOperationException("not implemented");
        }
    }

    public static final class Builder {
        private static final Entry[] OF_ENTRIES = new Entry[0];
        private static final PropertyPredicate NO_FILTER = new PropertyPredicate(){};
        private final Map<Integer, Entry> alternatives = new HashMap<Integer, Entry>();
        private boolean filterProperties;
        private final CursorFactory cursors;

        public NeighbourCursor build() {
            Object[] entries = this.alternatives.values().toArray(OF_ENTRIES);
            Arrays.sort(entries);
            if (this.filterProperties) {
                return new FilteringExplicitLabels(this.cursors, (Entry[])entries);
            }
            return new ExplicitLabels(this.cursors, (Entry[])entries);
        }

        public Builder outgoing(int label) {
            return this.outgoing(label, NO_FILTER);
        }

        public Builder outgoing(int label, PropertyPredicate edgeProperties) {
            if (Objects.requireNonNull(edgeProperties, "Edge PropertyPredicate") != NO_FILTER) {
                this.filterProperties = true;
            }
            this.alternatives.compute(label, (key, entry) -> {
                if (entry == null) {
                    entry = new Entry((int)key);
                }
                entry.outgoing(edgeProperties);
                return entry;
            });
            return this;
        }

        public Builder incoming(int label) {
            return this.incoming(label, NO_FILTER);
        }

        public Builder incoming(int label, PropertyPredicate edgeProperties) {
            if (Objects.requireNonNull(edgeProperties, "Edge PropertyPredicate") != NO_FILTER) {
                this.filterProperties = true;
            }
            this.alternatives.compute(label, (key, entry) -> {
                if (entry == null) {
                    entry = new Entry((int)key);
                }
                entry.incoming(edgeProperties);
                return entry;
            });
            return this;
        }

        public Builder any(int label) {
            return this.any(label, NO_FILTER);
        }

        public Builder any(int label, PropertyPredicate edgeProperties) {
            if (Objects.requireNonNull(edgeProperties, "Edge PropertyPredicate") != NO_FILTER) {
                this.filterProperties = true;
            }
            this.alternatives.compute(label, (key, entry) -> {
                if (entry == null) {
                    entry = new Entry((int)key);
                }
                entry.any(edgeProperties);
                return entry;
            });
            return this;
        }

        private Builder(CursorFactory cursors) {
            this.cursors = cursors;
        }

        private static final class Entry
        implements Comparable<Entry> {
            final int label;
            PropertyPredicate incoming;
            PropertyPredicate outgoing;
            PropertyPredicate any;

            Entry(int label) {
                this.label = label;
            }

            @Override
            public int compareTo(Entry that) {
                return this.label - that.label;
            }

            void outgoing(PropertyPredicate predicate) {
                if (this.any != null || this.outgoing != null) {
                    throw new IllegalStateException("Already specified");
                }
                if (this.incoming == predicate) {
                    this.any = predicate;
                    this.incoming = null;
                } else {
                    this.outgoing = predicate;
                }
            }

            void incoming(PropertyPredicate predicate) {
                if (this.any != null || this.incoming != null) {
                    throw new IllegalStateException("Already specified");
                }
                if (this.outgoing == predicate) {
                    this.any = predicate;
                    this.outgoing = null;
                } else {
                    this.incoming = predicate;
                }
            }

            void any(PropertyPredicate predicate) {
                if (this.any != null || this.outgoing != null || this.incoming != null) {
                    throw new IllegalStateException("Already specified");
                }
                this.any = predicate;
            }
        }
    }
}

