/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Clock;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.annotations.service.Service;
import org.neo4j.batchimport.api.AdditionalInitialIds;
import org.neo4j.batchimport.api.BatchImporter;
import org.neo4j.batchimport.api.IncrementalBatchImporter;
import org.neo4j.batchimport.api.IndexImporterFactory;
import org.neo4j.batchimport.api.Monitor;
import org.neo4j.batchimport.api.ReadBehaviour;
import org.neo4j.batchimport.api.input.Collector;
import org.neo4j.batchimport.api.input.Input;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.consistency.checking.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.ConsistencyFlags;
import org.neo4j.consistency.report.ConsistencySummaryStatistics;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.schema.IndexConfigCompleter;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseFile;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.layout.block.BlockDatabaseExistMarker;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.impl.muninn.VersionStorage;
import org.neo4j.io.pagecache.prefetch.PagePrefetcher;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.api.index.IndexProvidersAccess;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.locking.LockManager;
import org.neo4j.kernel.impl.transaction.log.LogTailLogVersionsMetadata;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadata;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadataFactory;
import org.neo4j.lock.LockService;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.monitoring.ExceptionHandlerService;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.service.Services;
import org.neo4j.storageengine.OperationMode;
import org.neo4j.storageengine.StoreIdGenerator;
import org.neo4j.storageengine.VectorStoreCreator;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.ConstraintRuleAccessor;
import org.neo4j.storageengine.api.LogFilesInitializer;
import org.neo4j.storageengine.api.LogMetadataProvider;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.SchemaRule44;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageFilesState;
import org.neo4j.storageengine.api.StoreFormatLimits;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.StoreVersion;
import org.neo4j.storageengine.api.StoreVersionCheck;
import org.neo4j.storageengine.api.StoreVersionIdentifier;
import org.neo4j.storageengine.migration.SchemaRuleMigrationAccessExtended;
import org.neo4j.storageengine.migration.StoreMigrationParticipant;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.token.TokenHolders;

@Service
public interface StorageEngineFactory {
    public static final Selector SELECTOR;

    public String name();

    public byte id();

    public StoreId retrieveStoreId(FileSystemAbstraction var1, DatabaseLayout var2, PageCache var3, CursorContext var4) throws IOException;

    public StoreVersionCheck versionCheck(FileSystemAbstraction var1, DatabaseLayout var2, Config var3, PageCache var4, LogService var5, CursorContextFactory var6);

    public Optional<? extends StoreVersion> versionInformation(StoreVersionIdentifier var1);

    public List<StoreMigrationParticipant> migrationParticipants(FileSystemAbstraction var1, Config var2, PageCache var3, JobScheduler var4, LogService var5, MemoryTracker var6, PageCacheTracer var7, CursorContextFactory var8, boolean var9, long var10);

    public StorageEngine instantiate(FileSystemAbstraction var1, Clock var2, DatabaseLayout var3, Config var4, PageCache var5, TokenHolders var6, SchemaState var7, ConstraintRuleAccessor var8, IndexConfigCompleter var9, LockService var10, IdGeneratorFactory var11, DatabaseHealth var12, InternalLogProvider var13, InternalLogProvider var14, RecoveryCleanupWorkCollector var15, LogMetadataProvider var16, MemoryTracker var17, CursorContextFactory var18, PageCacheTracer var19, VersionStorage var20, PagePrefetcher var21, StoreIdGenerator var22, DependencyResolver var23, ExceptionHandlerService var24, OperationMode var25, VectorStoreCreator var26) throws IOException;

    public List<Path> listStorageFiles(FileSystemAbstraction var1, DatabaseLayout var2) throws IOException;

    public boolean storageExists(FileSystemAbstraction var1, DatabaseLayout var2);

    default public boolean storageExists(FileSystemAbstraction fileSystem, Neo4jLayout neo4jLayout, String databaseName) {
        return this.storageExists(fileSystem, this.databaseLayout(neo4jLayout, databaseName));
    }

    default public boolean supportedFormat(String format) {
        return this.supportedFormats(true).contains(format);
    }

    public Set<String> supportedFormats(boolean var1);

    public boolean isDeprecated(String var1);

    public StoreFormatLimits limitsForFormat(String var1) throws IllegalStateException;

    public boolean fitsWithinStoreFormatLimits(StoreFormatLimits var1, DatabaseLayout var2, FileSystemAbstraction var3, PageCache var4, Config var5) throws IOException;

    public int tokenLengthLimit();

    public MetadataProvider transactionMetaDataStore(FileSystemAbstraction var1, DatabaseLayout var2, Config var3, PageCache var4, DatabaseReadOnlyChecker var5, CursorContextFactory var6, PageCacheTracer var7) throws IOException;

    public Optional<UUID> databaseIdUuid(FileSystemAbstraction var1, DatabaseLayout var2, PageCache var3, CursorContext var4);

    public List<SchemaRule44> load44SchemaRules(FileSystemAbstraction var1, PageCache var2, PageCacheTracer var3, Config var4, DatabaseLayout var5, CursorContextFactory var6, LogTailLogVersionsMetadata var7, MemoryTracker var8);

    public List<SchemaRule> loadSchemaRules(FileSystemAbstraction var1, PageCache var2, PageCacheTracer var3, Config var4, DatabaseLayout var5, boolean var6, Function<SchemaRule, SchemaRule> var7, CursorContextFactory var8, MemoryTracker var9);

    public TokenHolders loadReadOnlyTokens(FileSystemAbstraction var1, DatabaseLayout var2, Config var3, PageCache var4, PageCacheTracer var5, boolean var6, CursorContextFactory var7, MemoryTracker var8);

    public SchemaRuleMigrationAccessExtended schemaRuleMigrationAccess(FileSystemAbstraction var1, PageCache var2, PageCacheTracer var3, Config var4, DatabaseLayout var5, CursorContextFactory var6, MemoryTracker var7, LogTailMetadata var8) throws IOException;

    public StorageFilesState checkStoreFileState(FileSystemAbstraction var1, DatabaseLayout var2, PageCache var3, KernelVersionProvider var4, boolean var5);

    public CommandReaderFactory commandReaderFactory();

    public DatabaseLayout databaseLayout(Neo4jLayout var1, String var2);

    public DatabaseLayout formatSpecificDatabaseLayout(DatabaseLayout var1);

    public BatchImporter batchImporter(DatabaseLayout var1, FileSystemAbstraction var2, boolean var3, PageCacheTracer var4, org.neo4j.batchimport.api.Configuration var5, LogService var6, PrintStream var7, boolean var8, AdditionalInitialIds var9, LogTailMetadataFactory var10, Config var11, Monitor var12, JobScheduler var13, Collector var14, LogFilesInitializer var15, IndexImporterFactory var16, MemoryTracker var17, CursorContextFactory var18, IndexProvidersAccess var19, int var20, DependencyResolver var21);

    public Input asBatchImporterInput(DatabaseLayout var1, FileSystemAbstraction var2, PageCache var3, PageCacheTracer var4, Config var5, MemoryTracker var6, ReadBehaviour var7, boolean var8, CursorContextFactory var9, LogTailMetadata var10);

    public IncrementalBatchImporter incrementalBatchImporter(DatabaseLayout var1, FileSystemAbstraction var2, PageCacheTracer var3, org.neo4j.batchimport.api.Configuration var4, LogService var5, PrintStream var6, boolean var7, LogTailMetadataFactory var8, Config var9, Monitor var10, JobScheduler var11, Collector var12, LogFilesInitializer var13, IndexImporterFactory var14, MemoryTracker var15, CursorContextFactory var16, IndexProvidersAccess var17, int var18, DependencyResolver var19);

    public boolean supportsVectorData();

    public LockManager createLockManager(Config var1, SystemNanoClock var2);

    public long optimalAvailableConsistencyCheckerMemory(FileSystemAbstraction var1, DatabaseLayout var2, Config var3, PageCache var4);

    public void consistencyCheck(FileSystemAbstraction var1, DatabaseLayout var2, Config var3, PageCache var4, IndexProviderMap var5, InternalLog var6, InternalLog var7, ConsistencySummaryStatistics var8, int var9, long var10, OutputStream var12, boolean var13, ConsistencyFlags var14, CursorContextFactory var15, PageCacheTracer var16, LogTailMetadata var17, MemoryTracker var18) throws ConsistencyCheckIncompleteException;

    public ImmutableSet<OpenOption> getStoreOpenOptions(FileSystemAbstraction var1, PageCache var2, DatabaseLayout var3, CursorContextFactory var4);

    public static StorageEngineFactory defaultStorageEngine() {
        String name = "record";
        return StorageEngineFactory.allAvailableStorageEngines().stream().filter(e -> e.name().equals(name)).findFirst().orElseThrow(() -> new IllegalArgumentException("No storage engine matching name '" + name + "'. Available storage engines are: " + StorageEngineFactory.allAvailableStorageEngines().stream().map(e -> "'" + e.name() + "'").collect(Collectors.joining(", "))));
    }

    public static Collection<StorageEngineFactory> allAvailableStorageEngines() {
        return StorageEngineFactoryHolder.ALL_ENGINE_FACTORIES;
    }

    public static Optional<StorageEngineFactory> selectStorageEngine(FileSystemAbstraction fs, DatabaseLayout databaseLayout) {
        return StorageEngineFactory.allAvailableStorageEngines().stream().filter(engine -> engine.storageExists(fs, databaseLayout)).findFirst();
    }

    public static Optional<StorageEngineFactory> selectStorageEngine(FileSystemAbstraction fs, Neo4jLayout neo4jLayout, String databaseName) {
        return StorageEngineFactory.allAvailableStorageEngines().stream().filter(engine -> engine.storageExists(fs, neo4jLayout, databaseName)).findFirst();
    }

    public static StorageEngineFactory selectStorageEngine(Configuration configuration) {
        return StorageEngineFactory.findEngineForFormatOrThrow(configuration);
    }

    public static StorageEngineFactory selectStorageEngine(FileSystemAbstraction fs, DatabaseLayout databaseLayout, Configuration configuration) {
        return StorageEngineFactory.selectStorageEngine(fs, databaseLayout).orElseGet(() -> {
            StorageEngineFactory.validateNotKnownFormat(fs, databaseLayout);
            return configuration == null || "system".equals(databaseLayout.getDatabaseName()) ? StorageEngineFactory.defaultStorageEngine() : StorageEngineFactory.findEngineForFormatOrThrow(configuration);
        });
    }

    private static void validateNotKnownFormat(FileSystemAbstraction fs, DatabaseLayout databaseLayout) {
        if (fs.isDirectory(databaseLayout.databaseDirectory())) {
            if (!1.$assertionsDisabled && !StorageEngineFactory.selectStorageEngine(fs, databaseLayout).isEmpty()) {
                throw new AssertionError();
            }
            if (fs.fileExists(databaseLayout.file((DatabaseFile)BlockDatabaseExistMarker.INSTANCE))) {
                throw new IllegalArgumentException("Block format detected for database " + databaseLayout.getDatabaseName() + " but unavailable in this edition.");
            }
        }
    }

    public static StorageEngineFactory selectStorageEngine(byte id) {
        return StorageEngineFactory.allAvailableStorageEngines().stream().filter(engine -> engine.id() == id).findAny().orElseThrow(() -> new IllegalArgumentException("No storage engine factory with id " + id + ". Available engines are: " + StorageEngineFactory.allAvailableStorageEngines().stream().map(e -> e.name() + ":" + e.id()).collect(Collectors.joining(", "))));
    }

    public static boolean isFormatDeprecated(String formatName) {
        try {
            return StorageEngineFactory.findEngineForFormatOrThrow(formatName).isDeprecated(formatName);
        }
        catch (IllegalArgumentException ignored) {
            return false;
        }
    }

    private static StorageEngineFactory findEngineForFormatOrThrow(Configuration configuration) {
        String name = (String)configuration.get(GraphDatabaseSettings.db_format);
        return StorageEngineFactory.findEngineForFormatOrThrow(name);
    }

    private static StorageEngineFactory findEngineForFormatOrThrow(String name) {
        return StorageEngineFactory.allAvailableStorageEngines().stream().filter(engine -> engine.supportedFormat(name)).findFirst().orElseThrow(() -> {
            String allFormats = StorageEngineFactory.allAvailableStorageEngines().stream().flatMap(sef -> sef.supportedFormats(false).stream()).distinct().collect(Collectors.joining("', '", "'", "'"));
            return new IllegalArgumentException(String.format("No supported database format '%s'. Available formats are: %s.", name, allFormats));
        });
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        SELECTOR = StorageEngineFactory::selectStorageEngine;
    }

    public static final class StorageEngineFactoryHolder {
        static final Collection<StorageEngineFactory> ALL_ENGINE_FACTORIES = StorageEngineFactoryHolder.loadFactories();

        private static Collection<StorageEngineFactory> loadFactories() {
            return Services.loadAll(StorageEngineFactory.class);
        }
    }

    @FunctionalInterface
    public static interface Selector {
        public Optional<StorageEngineFactory> selectStorageEngine(FileSystemAbstraction var1, DatabaseLayout var2);
    }
}

