/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.IntPredicate;

public abstract class PropertySelection {
    public static final int UNKNOWN_NUMBER_OF_KEYS = -1;
    protected final boolean fallbackKeysOnly;
    protected final IntPredicate valueSelection;
    public static final PropertySelection ALL_PROPERTIES = PropertySelection.allProperties(false, null);
    public static final PropertySelection ALL_PROPERTY_KEYS = PropertySelection.allProperties(true, null);
    public static final PropertySelection NO_PROPERTIES = new PropertySelection(true, null){

        @Override
        public boolean isLimited() {
            return true;
        }

        @Override
        public int numberOfKeys() {
            return 0;
        }

        @Override
        public int key(int index) {
            throw new IllegalStateException("This selection has no keys");
        }

        @Override
        public boolean test(int key) {
            return false;
        }

        @Override
        public int lowestKey() {
            return -1;
        }

        @Override
        public int highestKey() {
            return -1;
        }

        @Override
        public PropertySelection excluding(IntPredicate filter) {
            return this;
        }
    };

    protected PropertySelection(boolean keysOnly, IntPredicate valueSelection) {
        this.fallbackKeysOnly = keysOnly;
        this.valueSelection = valueSelection;
    }

    public abstract boolean isLimited();

    public abstract int numberOfKeys();

    public boolean isEmpty() {
        return this.numberOfKeys() == 0;
    }

    public abstract int key(int var1);

    public abstract boolean test(int var1);

    public boolean includeValue(int key) {
        return this.valueSelection == null ? !this.fallbackKeysOnly : this.valueSelection.test(key);
    }

    public abstract int lowestKey();

    public abstract int highestKey();

    public abstract PropertySelection excluding(IntPredicate var1);

    public String toString() {
        return String.format("Property%sSelection", this.fallbackKeysOnly ? "Key" : "");
    }

    public static PropertySelection selection(int key) {
        return SingleKey.singleKey(false, key);
    }

    public static PropertySelection selection(int ... keys) {
        return PropertySelection.multiSelection(false, null, keys);
    }

    public static PropertySelection selection(IntPredicate valueSelection, int ... keys) {
        return PropertySelection.multiSelection(false, valueSelection, keys);
    }

    public static PropertySelection onlyKeysSelection(int ... keys) {
        return PropertySelection.multiSelection(true, null, keys);
    }

    private static PropertySelection multiSelection(boolean fallbackKeysOnly, IntPredicate valueSelection, int[] keys) {
        if (keys == null) {
            if (valueSelection == null) {
                return fallbackKeysOnly ? ALL_PROPERTY_KEYS : ALL_PROPERTIES;
            }
            return PropertySelection.allProperties(fallbackKeysOnly, valueSelection);
        }
        if (keys.length == 0) {
            return NO_PROPERTIES;
        }
        if (keys.length == 1) {
            int key = keys[0];
            if (valueSelection == null) {
                return key == -1 ? NO_PROPERTIES : SingleKey.singleKey(fallbackKeysOnly, key);
            }
            return SingleKey.singleKey(!valueSelection.test(key), key);
        }
        return new MultipleKeys(fallbackKeysOnly, valueSelection, keys);
    }

    private static PropertySelection allProperties(boolean keysOnly, IntPredicate valueSelection) {
        return new PropertySelection(keysOnly, valueSelection){

            @Override
            public boolean isLimited() {
                return false;
            }

            @Override
            public int numberOfKeys() {
                return -1;
            }

            @Override
            public int key(int index) {
                return -1;
            }

            @Override
            public boolean test(int key) {
                return true;
            }

            @Override
            public int lowestKey() {
                return 0;
            }

            @Override
            public int highestKey() {
                return Integer.MAX_VALUE;
            }

            @Override
            public PropertySelection excluding(IntPredicate filter) {
                return new AllExcept(this.fallbackKeysOnly, this.valueSelection, filter);
            }

            @Override
            public String toString() {
                return super.toString() + "[*]";
            }
        };
    }

    private static class SingleKey
    extends PropertySelection {
        private static final int LOW_ID_THRESHOLD = 128;
        private static final PropertySelection[] SINGLE_LOW_ID_SELECTIONS = new PropertySelection[128];
        private static final PropertySelection[] SINGLE_LOW_ID_KEY_SELECTIONS = new PropertySelection[128];
        private final int key;

        private static PropertySelection singleKey(boolean fallbackKeysOnly, int key) {
            if (key < 128 && key >= 0) {
                return fallbackKeysOnly ? SINGLE_LOW_ID_KEY_SELECTIONS[key] : SINGLE_LOW_ID_SELECTIONS[key];
            }
            return new SingleKey(fallbackKeysOnly, key);
        }

        private SingleKey(boolean keysOnly, int key) {
            super(keysOnly, null);
            this.key = key;
        }

        @Override
        public boolean isLimited() {
            return true;
        }

        @Override
        public int numberOfKeys() {
            return 1;
        }

        @Override
        public int key(int index) {
            assert (index == 0);
            return this.key;
        }

        @Override
        public boolean test(int key) {
            return this.key == key;
        }

        @Override
        public int lowestKey() {
            return this.key;
        }

        @Override
        public int highestKey() {
            return this.key;
        }

        @Override
        public PropertySelection excluding(IntPredicate filter) {
            return filter.test(this.key) ? NO_PROPERTIES : this;
        }

        @Override
        public String toString() {
            return super.toString() + "[" + this.key + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SingleKey)) {
                return false;
            }
            SingleKey singleKey = (SingleKey)o;
            return this.key == singleKey.key;
        }

        public int hashCode() {
            return Objects.hashCode(this.key);
        }

        static {
            for (int key = 0; key < SINGLE_LOW_ID_SELECTIONS.length; ++key) {
                SingleKey.SINGLE_LOW_ID_SELECTIONS[key] = new SingleKey(false, key);
                SingleKey.SINGLE_LOW_ID_KEY_SELECTIONS[key] = new SingleKey(true, key);
            }
        }
    }

    private static class MultipleKeys
    extends PropertySelection {
        private final int[] keys;

        private MultipleKeys(boolean fallbackKeysOnly, IntPredicate valueSelection, int[] keys) {
            super(fallbackKeysOnly, valueSelection);
            this.keys = this.cloneAndCleanUp(keys);
        }

        private int[] cloneAndCleanUp(int[] suppliedKeys) {
            int[] keys = (int[])suppliedKeys.clone();
            Arrays.sort(keys);
            if (keys[0] == -1) {
                int start;
                for (start = 1; start < keys.length && keys[start] == -1; ++start) {
                }
                keys = Arrays.copyOfRange(keys, start, keys.length);
            }
            return keys;
        }

        @Override
        public boolean isLimited() {
            return true;
        }

        @Override
        public int numberOfKeys() {
            return this.keys.length;
        }

        @Override
        public int key(int index) {
            assert (index >= 0 && index < this.keys.length);
            return this.keys[index];
        }

        @Override
        public boolean test(int key) {
            for (int k : this.keys) {
                if (k != key) continue;
                return true;
            }
            return false;
        }

        @Override
        public int lowestKey() {
            return this.keys[0];
        }

        @Override
        public int highestKey() {
            return this.keys[this.keys.length - 1];
        }

        @Override
        public PropertySelection excluding(IntPredicate filter) {
            int[] newKeys = new int[this.keys.length];
            int t = 0;
            for (int key : this.keys) {
                if (filter.test(key)) continue;
                newKeys[t++] = key;
            }
            if (t == this.keys.length) {
                return this;
            }
            return PropertySelection.multiSelection(this.fallbackKeysOnly, this.valueSelection, Arrays.copyOf(newKeys, t));
        }

        @Override
        public String toString() {
            return super.toString() + "[" + Arrays.toString(this.keys) + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MultipleKeys)) {
                return false;
            }
            MultipleKeys that = (MultipleKeys)o;
            return Objects.deepEquals(this.keys, that.keys);
        }

        public int hashCode() {
            return Arrays.hashCode(this.keys);
        }
    }

    private static class AllExcept
    extends PropertySelection {
        private final IntPredicate excluded;

        AllExcept(boolean fallbackKeysOnly, IntPredicate valueSelection, IntPredicate excluded) {
            super(fallbackKeysOnly, valueSelection);
            this.excluded = excluded;
        }

        @Override
        public boolean isLimited() {
            return true;
        }

        @Override
        public int numberOfKeys() {
            return -1;
        }

        @Override
        public int key(int index) {
            throw new IllegalStateException("This selection has no discrete number of keys");
        }

        @Override
        public boolean test(int key) {
            return !this.excluded.test(key);
        }

        @Override
        public int lowestKey() {
            return 0;
        }

        @Override
        public int highestKey() {
            return Integer.MAX_VALUE;
        }

        @Override
        public PropertySelection excluding(IntPredicate filter) {
            return new AllExcept(this.fallbackKeysOnly, this.valueSelection, this.excluded.or(filter));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AllExcept)) {
                return false;
            }
            AllExcept allExcept = (AllExcept)o;
            return Objects.equals(this.excluded, allExcept.excluded);
        }

        public int hashCode() {
            return Objects.hashCode(this.excluded);
        }
    }
}

