/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.schema.IndexConfigCompleter;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.StorageEngineIndexingBehaviour;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.MinimalIndexAccessor;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.migration.StoreMigrationParticipant;
import org.neo4j.values.ElementIdMapper;

public abstract class IndexProvider
extends LifecycleAdapter
implements IndexConfigCompleter {
    public static final IndexProvider EMPTY = new IndexProvider(KernelVersion.EARLIEST, new IndexProviderDescriptor("no-index-provider", "1.0"), IndexDirectoryStructure.NONE){
        private final IndexAccessor singleWriter = IndexAccessor.EMPTY;
        private final IndexPopulator singlePopulator = IndexPopulator.EMPTY;
        private final MinimalIndexAccessor singleMinimalAccessor = MinimalIndexAccessor.EMPTY;

        public IndexDescriptor completeConfiguration(IndexDescriptor index, StorageEngineIndexingBehaviour indexingBehaviour) {
            return index;
        }

        @Override
        public IndexAccessor getOnlineAccessor(IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, TokenNameLookup tokenNameLookup, ElementIdMapper elementIdMapper, ImmutableSet<OpenOption> openOptions, boolean readOnly, StorageEngineIndexingBehaviour indexingBehaviour) {
            return this.singleWriter;
        }

        @Override
        public MinimalIndexAccessor getMinimalIndexAccessor(IndexDescriptor descriptor, boolean forRebuildDuringRecovery) {
            return this.singleMinimalAccessor;
        }

        @Override
        public IndexPopulator getPopulator(IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, ByteBufferFactory bufferFactory, MemoryTracker memoryTracker, TokenNameLookup tokenNameLookup, ElementIdMapper elementIdMapper, ImmutableSet<OpenOption> openOptions, StorageEngineIndexingBehaviour indexingBehaviour, IndexPopulator.Configuration configuration) {
            return this.singlePopulator;
        }

        @Override
        public InternalIndexState getInitialState(IndexDescriptor descriptor, CursorContext cursorContext, ImmutableSet<OpenOption> openOptions) {
            return InternalIndexState.ONLINE;
        }

        @Override
        public IndexPrototype validatePrototype(IndexPrototype prototype) {
            return prototype;
        }

        @Override
        public IndexType getIndexType() {
            return IndexType.RANGE;
        }

        @Override
        public StoreMigrationParticipant storeMigrationParticipant(FileSystemAbstraction fs, PageCache pageCache, PageCacheTracer pageCacheTracer, StorageEngineFactory storageEngineFactory, CursorContextFactory contextFactory) {
            return StoreMigrationParticipant.NOT_PARTICIPATING;
        }

        @Override
        public String getPopulationFailure(IndexDescriptor descriptor, CursorContext cursorContext, ImmutableSet<OpenOption> openOptions) {
            return "";
        }
    };
    private final KernelVersion minimumRequiredVersion;
    private final IndexProviderDescriptor providerDescriptor;
    private final IndexDirectoryStructure.Factory directoryStructureFactory;
    private final IndexDirectoryStructure directoryStructure;

    protected IndexProvider(IndexProvider copySource) {
        this(copySource.minimumRequiredVersion, copySource.providerDescriptor, copySource.directoryStructureFactory);
    }

    protected IndexProvider(KernelVersion minimumRequiredVersion, IndexProviderDescriptor descriptor, IndexDirectoryStructure.Factory directoryStructureFactory) {
        this.minimumRequiredVersion = minimumRequiredVersion;
        this.directoryStructureFactory = directoryStructureFactory;
        assert (descriptor != null);
        this.providerDescriptor = descriptor;
        this.directoryStructure = directoryStructureFactory.forProvider(descriptor);
    }

    public KernelVersion getMinimumRequiredVersion() {
        return this.minimumRequiredVersion;
    }

    public abstract MinimalIndexAccessor getMinimalIndexAccessor(IndexDescriptor var1, boolean var2);

    public abstract IndexPopulator getPopulator(IndexDescriptor var1, IndexSamplingConfig var2, ByteBufferFactory var3, MemoryTracker var4, TokenNameLookup var5, ElementIdMapper var6, ImmutableSet<OpenOption> var7, StorageEngineIndexingBehaviour var8, IndexPopulator.Configuration var9);

    public final IndexPopulator getPopulator(IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, ByteBufferFactory bufferFactory, MemoryTracker memoryTracker, TokenNameLookup tokenNameLookup, ElementIdMapper elementIdMapper, ImmutableSet<OpenOption> openOptions, StorageEngineIndexingBehaviour indexingBehaviour) {
        return this.getPopulator(descriptor, samplingConfig, bufferFactory, memoryTracker, tokenNameLookup, elementIdMapper, openOptions, indexingBehaviour, IndexPopulator.DEFAULT_CONFIGURATION);
    }

    public final IndexAccessor getOnlineAccessor(IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, TokenNameLookup tokenNameLookup, ElementIdMapper elementIdMapper, ImmutableSet<OpenOption> openOptions, StorageEngineIndexingBehaviour indexingBehaviour) throws IOException {
        return this.getOnlineAccessor(descriptor, samplingConfig, tokenNameLookup, elementIdMapper, openOptions, false, indexingBehaviour);
    }

    public abstract IndexAccessor getOnlineAccessor(IndexDescriptor var1, IndexSamplingConfig var2, TokenNameLookup var3, ElementIdMapper var4, ImmutableSet<OpenOption> var5, boolean var6, StorageEngineIndexingBehaviour var7) throws IOException;

    public abstract String getPopulationFailure(IndexDescriptor var1, CursorContext var2, ImmutableSet<OpenOption> var3);

    public abstract InternalIndexState getInitialState(IndexDescriptor var1, CursorContext var2, ImmutableSet<OpenOption> var3);

    public abstract IndexPrototype validatePrototype(IndexPrototype var1);

    public IndexProviderDescriptor getProviderDescriptor() {
        return this.providerDescriptor;
    }

    public abstract IndexType getIndexType();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        IndexProvider other = (IndexProvider)((Object)o);
        return this.providerDescriptor.equals((Object)other.providerDescriptor);
    }

    public int hashCode() {
        return this.providerDescriptor.hashCode();
    }

    public IndexDirectoryStructure directoryStructure() {
        return this.directoryStructure;
    }

    public abstract StoreMigrationParticipant storeMigrationParticipant(FileSystemAbstraction var1, PageCache var2, PageCacheTracer var3, StorageEngineFactory var4, CursorContextFactory var5);

    public static class Delegating
    extends IndexProvider {
        private final IndexProvider provider;

        public Delegating(IndexProvider provider) {
            super(provider);
            this.provider = provider;
        }

        @Override
        public MinimalIndexAccessor getMinimalIndexAccessor(IndexDescriptor descriptor, boolean forRebuildDuringRecovery) {
            return this.provider.getMinimalIndexAccessor(descriptor, forRebuildDuringRecovery);
        }

        @Override
        public IndexPopulator getPopulator(IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, ByteBufferFactory bufferFactory, MemoryTracker memoryTracker, TokenNameLookup tokenNameLookup, ElementIdMapper elementIdMapper, ImmutableSet<OpenOption> openOptions, StorageEngineIndexingBehaviour indexingBehaviour, IndexPopulator.Configuration configuration) {
            return this.provider.getPopulator(descriptor, samplingConfig, bufferFactory, memoryTracker, tokenNameLookup, elementIdMapper, openOptions, indexingBehaviour, configuration);
        }

        @Override
        public IndexAccessor getOnlineAccessor(IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, TokenNameLookup tokenNameLookup, ElementIdMapper elementIdMapper, ImmutableSet<OpenOption> openOptions, boolean readOnly, StorageEngineIndexingBehaviour indexingBehaviour) throws IOException {
            return this.provider.getOnlineAccessor(descriptor, samplingConfig, tokenNameLookup, elementIdMapper, openOptions, readOnly, indexingBehaviour);
        }

        @Override
        public String getPopulationFailure(IndexDescriptor descriptor, CursorContext cursorContext, ImmutableSet<OpenOption> openOptions) {
            return this.provider.getPopulationFailure(descriptor, cursorContext, openOptions);
        }

        @Override
        public InternalIndexState getInitialState(IndexDescriptor descriptor, CursorContext cursorContext, ImmutableSet<OpenOption> openOptions) {
            return this.provider.getInitialState(descriptor, cursorContext, openOptions);
        }

        @Override
        public IndexPrototype validatePrototype(IndexPrototype prototype) {
            return this.provider.validatePrototype(prototype);
        }

        @Override
        public IndexProviderDescriptor getProviderDescriptor() {
            return this.provider.getProviderDescriptor();
        }

        @Override
        public IndexType getIndexType() {
            return this.provider.getIndexType();
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof IndexProvider && this.provider.equals(o);
        }

        @Override
        public int hashCode() {
            return this.provider.hashCode();
        }

        @Override
        public IndexDirectoryStructure directoryStructure() {
            return this.provider.directoryStructure();
        }

        @Override
        public StoreMigrationParticipant storeMigrationParticipant(FileSystemAbstraction fs, PageCache pageCache, PageCacheTracer pageCacheTracer, StorageEngineFactory storageEngineFactory, CursorContextFactory contextFactory) {
            return this.provider.storeMigrationParticipant(fs, pageCache, pageCacheTracer, storageEngineFactory, contextFactory);
        }

        public void init() throws Exception {
            this.provider.init();
        }

        public void start() throws Exception {
            this.provider.start();
        }

        public void stop() throws Exception {
            this.provider.stop();
        }

        public void shutdown() throws Exception {
            this.provider.shutdown();
        }

        public IndexDescriptor completeConfiguration(IndexDescriptor index, StorageEngineIndexingBehaviour indexingBehaviour) {
            return this.provider.completeConfiguration(index, indexingBehaviour);
        }
    }

    public static interface Monitor {
        public void failedToOpenIndex(IndexDescriptor var1, String var2, Exception var3);

        public void recoveryCleanupRegistered(Path var1, IndexDescriptor var2);

        public void recoveryCleanupStarted(Path var1, IndexDescriptor var2);

        public void recoveryCleanupFinished(Path var1, IndexDescriptor var2, long var3, long var5, long var7, long var9);

        public void recoveryCleanupClosed(Path var1, IndexDescriptor var2);

        public void recoveryCleanupFailed(Path var1, IndexDescriptor var2, Throwable var3);
    }
}

