/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.entry.LogFormat;

public enum DatabaseVersion {
    V0(0, -1, -1, -1),
    V1(1, KernelVersion.GLORIOUS_FUTURE.version(), 5, LogFormat.V11.getVersionByte()),
    V2(2, KernelVersion.GLORIOUS_FUTURE.version(), 6, LogFormat.V11.getVersionByte());

    private static final Map<Byte, DatabaseVersion> BY_VERSION;
    private static final DatabaseVersion LATEST_DATABASE_VERSION;
    private final byte identifier;
    private final byte kernelVersion;
    private final int contentMarshallerVersion;
    private final byte logFormatHeader;

    private DatabaseVersion(byte identifier, byte kernelVersion, int contentMarshallerVersion, byte logFormatHeader) {
        this.identifier = identifier;
        this.kernelVersion = kernelVersion;
        this.contentMarshallerVersion = contentMarshallerVersion;
        this.logFormatHeader = logFormatHeader;
    }

    public byte identifier() {
        return this.identifier;
    }

    public byte kernelVersion() {
        return this.kernelVersion;
    }

    public int contentMarshallerVersion() {
        return this.contentMarshallerVersion;
    }

    public byte getLogFormatHeader() {
        return this.logFormatHeader;
    }

    public static DatabaseVersion getLatestVersion() {
        return LATEST_DATABASE_VERSION;
    }

    public boolean isHigherThan(DatabaseVersion other) {
        return this.identifier > other.identifier;
    }

    public static DatabaseVersion fromVersionNumber(byte versionNumber) {
        DatabaseVersion v = BY_VERSION.get(versionNumber);
        if (v == null) {
            throw new IllegalArgumentException("DatabaseVersion with version number " + versionNumber + " does not exist");
        }
        return v;
    }

    static {
        BY_VERSION = new HashMap<Byte, DatabaseVersion>();
        for (DatabaseVersion e : DatabaseVersion.values()) {
            BY_VERSION.put(e.identifier, e);
        }
        LATEST_DATABASE_VERSION = V2;
    }
}

