/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.security;

import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.kernel.api.security.SecurityContext;

public class SecurityExceptionLogger {
    protected final AbstractSecurityLog securityLog;

    public SecurityExceptionLogger(AbstractSecurityLog securityLog) {
        this.securityLog = securityLog;
    }

    public <T extends Throwable> T logAndGet(T exception) {
        this.securityLog.error(((ErrorGqlStatusObject)exception).legacyMessage(), exception, GqlStatusInfoCodes.STATUS_42NFF.getGqlStatus());
        return exception;
    }

    public <T extends Throwable> T logAndGet(SecurityContext context, T exception) {
        this.securityLog.error(context, ((ErrorGqlStatusObject)exception).legacyMessage(), exception, GqlStatusInfoCodes.STATUS_42NFF.getGqlStatus());
        return exception;
    }

    public <T extends Throwable> T logAndGet(SecurityContext context, String message, T exception) {
        this.securityLog.error(context, message, exception, GqlStatusInfoCodes.STATUS_42NFF.getGqlStatus());
        return exception;
    }

    public <T extends Throwable> T logAndGet(LoginContext context, T exception) {
        this.securityLog.error(context, ((ErrorGqlStatusObject)exception).legacyMessage(), exception, GqlStatusInfoCodes.STATUS_42NFF.getGqlStatus());
        return exception;
    }

    public <T extends Throwable> T logAndGet(LoginContext context, String database, String message, T exception) {
        this.securityLog.error(context, database, message, exception, GqlStatusInfoCodes.STATUS_42NFF.getGqlStatus());
        return exception;
    }

    public <T extends Throwable> T logAndGet(LoginContext context, String database, T exception) {
        this.securityLog.error(context, database, ((ErrorGqlStatusObject)exception).legacyMessage(), exception, GqlStatusInfoCodes.STATUS_42NFF.getGqlStatus());
        return exception;
    }

    public <T extends Throwable> T logAndGet(String message, T exception) {
        this.securityLog.error(message, exception, GqlStatusInfoCodes.STATUS_42NFF.getGqlStatus());
        return exception;
    }
}

