/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.security;

import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.neo4j.util.Preconditions;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.utils.ValueBooleanLogic;

public interface PropertyRule
extends Predicate<Value> {
    public static PropertyRule newRule(int propertyKey, Value value, ComparisonOperator operator) {
        return new PropertyValueRule(propertyKey, value, operator);
    }

    public static PropertyRule newNullRule(int propertyKey, NullOperator operator) {
        return new NullPropertyRule(propertyKey, operator);
    }

    public int property();

    public record PropertyValueRule(int property, Value value, ComparisonOperator operator) implements PropertyRule
    {
        public PropertyValueRule {
            Preconditions.requireNonNull((Object)value, (String)"value must not be null");
        }

        @Override
        public boolean test(Value value) {
            return this.operator.test(value, this.value);
        }
    }

    public static enum ComparisonOperator implements BiPredicate<Value, Value>
    {
        GREATER_THAN(">"){

            @Override
            public boolean test(Value lhs, Value rhs) {
                return ValueBooleanLogic.greaterThan((AnyValue)lhs, (AnyValue)rhs).equals((Value)Values.TRUE);
            }
        }
        ,
        LESS_THAN("<"){

            @Override
            public boolean test(Value lhs, Value rhs) {
                return ValueBooleanLogic.lessThan((AnyValue)lhs, (AnyValue)rhs).equals((Value)Values.TRUE);
            }
        }
        ,
        GREATER_THAN_OR_EQUAL(">="){

            @Override
            public boolean test(Value lhs, Value rhs) {
                return ValueBooleanLogic.greaterThanOrEqual((AnyValue)lhs, (AnyValue)rhs).equals((Value)Values.TRUE);
            }
        }
        ,
        LESS_THAN_OR_EQUAL("<="){

            @Override
            public boolean test(Value lhs, Value rhs) {
                return ValueBooleanLogic.lessThanOrEqual((AnyValue)lhs, (AnyValue)rhs).equals((Value)Values.TRUE);
            }
        }
        ,
        EQUAL("="){

            @Override
            public boolean test(Value lhs, Value rhs) {
                return ValueBooleanLogic.equals((AnyValue)lhs, (AnyValue)rhs).equals((Value)Values.TRUE);
            }
        }
        ,
        NOT_EQUAL("<>"){

            @Override
            public boolean test(Value lhs, Value rhs) {
                return ValueBooleanLogic.notEquals((AnyValue)lhs, (AnyValue)rhs).equals((Value)Values.TRUE);
            }
        }
        ,
        IN("IN"){

            @Override
            public boolean test(Value lhs, Value rhs) {
                return ValueBooleanLogic.in((AnyValue)lhs, (AnyValue)rhs).equals((Value)Values.TRUE);
            }
        }
        ,
        NOT_IN("NOT IN"){

            @Override
            public boolean test(Value lhs, Value rhs) {
                return ValueBooleanLogic.not((AnyValue)ValueBooleanLogic.in((AnyValue)lhs, (AnyValue)rhs)).equals((Value)Values.TRUE);
            }

            @Override
            public String toPredicateString(String lhs, String rhs) {
                return String.format("NOT %s IN %s", lhs, rhs);
            }
        };

        private final String symbol;

        private ComparisonOperator(String symbol) {
            this.symbol = symbol;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public String toPredicateString(String lhs, String rhs) {
            return String.format("%s %s %s", lhs, this.getSymbol(), rhs);
        }
    }

    public record NullPropertyRule(int property, NullOperator operator) implements PropertyRule
    {
        @Override
        public boolean test(Value value) {
            return this.operator.test(value);
        }
    }

    public static enum NullOperator implements Predicate<Value>
    {
        IS_NULL("IS NULL"){

            @Override
            public boolean test(Value lhs) {
                return lhs == Values.NO_VALUE;
            }
        }
        ,
        IS_NOT_NULL("IS NOT NULL"){

            @Override
            public boolean test(Value lhs) {
                return lhs != Values.NO_VALUE;
            }
        };

        private final String symbol;

        private NullOperator(String symbol) {
            this.symbol = symbol;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public String toPredicateString(String lhs) {
            return String.format("%s %s", lhs, this.getSymbol());
        }
    }
}

