/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.security;

import java.util.Map;
import java.util.regex.Pattern;
import org.neo4j.gqlstatus.GqlStatus;
import org.neo4j.internal.helpers.Strings;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.Neo4jLogMessage;
import org.neo4j.logging.log4j.Neo4jMapMessage;

public abstract class AbstractSecurityLog {
    protected InternalLog inner;

    protected AbstractSecurityLog(InternalLog inner) {
        this.inner = inner;
    }

    public void debug(String message) {
        this.inner.debug((Neo4jLogMessage)new SecurityLogLine(message));
    }

    public void debug(SecurityContext context, String message) {
        AuthSubject subject = context.subject();
        this.inner.debug((Neo4jLogMessage)new SecurityLogLine(context.connectionInfo(), context.database(), subject.executingUser(), message, subject.authenticatedUser(), null));
    }

    public void info(String message) {
        this.inner.info((Neo4jLogMessage)new SecurityLogLine(message));
    }

    public void info(LoginContext context, String message) {
        AuthSubject subject = context.subject();
        this.inner.info((Neo4jLogMessage)new SecurityLogLine(context.connectionInfo(), null, subject.executingUser(), message, subject.authenticatedUser(), null));
    }

    public void info(SecurityContext context, String message) {
        AuthSubject subject = context.subject();
        this.inner.info((Neo4jLogMessage)new SecurityLogLine(context.connectionInfo(), context.database(), subject.executingUser(), message, subject.authenticatedUser(), null));
    }

    public void warn(String message) {
        this.inner.warn((Neo4jLogMessage)new SecurityLogLine(message));
    }

    public void warn(SecurityContext context, String message) {
        AuthSubject subject = context.subject();
        this.inner.warn((Neo4jLogMessage)new SecurityLogLine(context.connectionInfo(), context.database(), subject.executingUser(), message, subject.authenticatedUser(), null));
    }

    public void error(String message) {
        this.inner.error((Neo4jLogMessage)new SecurityLogLine(message));
    }

    public void error(ClientConnectionInfo connectionInfo, String message) {
        this.inner.error((Neo4jLogMessage)new SecurityLogLine(connectionInfo, null, null, message, null, null));
    }

    public void error(LoginContext context, String message) {
        AuthSubject subject = context.subject();
        this.inner.error((Neo4jLogMessage)new SecurityLogLine(context.connectionInfo(), null, subject.executingUser(), message, subject.authenticatedUser(), null));
    }

    public void error(LoginContext context, String database, String message) {
        AuthSubject subject = context.subject();
        this.inner.error((Neo4jLogMessage)new SecurityLogLine(context.connectionInfo(), database, subject.executingUser(), message, subject.authenticatedUser(), null));
    }

    public void error(LoginContext context, String message, Throwable throwable) {
        AuthSubject subject = context.subject();
        this.inner.error((Neo4jLogMessage)new SecurityLogLine(context.connectionInfo(), null, subject.executingUser(), message, subject.authenticatedUser(), null), throwable);
    }

    public void error(LoginContext context, String message, Throwable throwable, GqlStatus gqlStatus) {
        AuthSubject subject = context.subject();
        this.inner.error((Neo4jLogMessage)new SecurityLogLine(context.connectionInfo(), null, subject.executingUser(), message, subject.authenticatedUser(), gqlStatus), throwable);
    }

    public void error(LoginContext context, String database, String message, Throwable throwable) {
        AuthSubject subject = context.subject();
        this.inner.error((Neo4jLogMessage)new SecurityLogLine(context.connectionInfo(), database, subject.executingUser(), message, subject.authenticatedUser(), null), throwable);
    }

    public void error(LoginContext context, String database, String message, Throwable throwable, GqlStatus gqlStatus) {
        AuthSubject subject = context.subject();
        this.inner.error((Neo4jLogMessage)new SecurityLogLine(context.connectionInfo(), database, subject.executingUser(), message, subject.authenticatedUser(), gqlStatus), throwable);
    }

    public void error(SecurityContext context, String message) {
        AuthSubject subject = context.subject();
        this.inner.error((Neo4jLogMessage)new SecurityLogLine(context.connectionInfo(), context.database(), subject.executingUser(), message, subject.authenticatedUser(), null));
    }

    public void error(String message, Throwable throwable) {
        this.inner.error((Neo4jLogMessage)new SecurityLogLine(message), throwable);
    }

    public void error(String message, Throwable throwable, GqlStatus exceptionThrown) {
        this.inner.error((Neo4jLogMessage)new SecurityLogLine(null, null, null, message, null, exceptionThrown), throwable);
    }

    public void error(SecurityContext context, String message, Throwable throwable) {
        AuthSubject subject = context.subject();
        this.inner.error((Neo4jLogMessage)new SecurityLogLine(context.connectionInfo(), context.database(), subject.executingUser(), message, subject.authenticatedUser(), null), throwable);
    }

    public void error(SecurityContext context, String message, Throwable throwable, GqlStatus exceptionThrown) {
        AuthSubject subject = context.subject();
        this.inner.error((Neo4jLogMessage)new SecurityLogLine(context.connectionInfo(), context.database(), subject.executingUser(), message, subject.authenticatedUser(), exceptionThrown), throwable);
    }

    public boolean isDebugEnabled() {
        return this.inner.isDebugEnabled();
    }

    static class SecurityLogLine
    extends Neo4jMapMessage {
        private final String executingUser;
        private final String message;
        private final String authenticatedUser;
        private final GqlStatus exceptionThrown;
        private static final Pattern NEWLINE_PATTERN = Pattern.compile("\\R+");

        SecurityLogLine(String message) {
            this(null, null, null, message, null, null);
        }

        SecurityLogLine(ClientConnectionInfo connectionInfo, String database, String executingUser, String message, String authenticatedUser, GqlStatus exceptionThrown) {
            super(7);
            String sourceString = connectionInfo != null ? connectionInfo.asConnectionDetails() : "";
            this.executingUser = executingUser;
            this.message = NEWLINE_PATTERN.matcher(message).replaceAll(" ");
            this.authenticatedUser = authenticatedUser;
            this.exceptionThrown = exceptionThrown;
            this.with("type", "security");
            this.with("source", sourceString);
            if (database != null) {
                this.with("database", database);
            }
            if (executingUser != null && !executingUser.isEmpty()) {
                this.with("executingUser", executingUser);
            }
            if (authenticatedUser != null && !authenticatedUser.isEmpty()) {
                this.with("authenticatedUser", authenticatedUser);
            }
            if (exceptionThrown != null) {
                this.with("errorInfo", Map.of("GQLSTATUS", exceptionThrown.gqlStatusString()));
            }
            this.with("message", this.message);
        }

        protected void formatAsString(StringBuilder sb) {
            if (this.executingUser != null && !this.executingUser.isEmpty()) {
                if (this.executingUser.equals(this.authenticatedUser)) {
                    sb.append("[").append(Strings.escape((String)this.executingUser)).append("]: ");
                } else {
                    sb.append(String.format("[%s:%s]: ", Strings.escape((String)this.authenticatedUser), Strings.escape((String)this.executingUser)));
                }
            }
            if (this.exceptionThrown != null) {
                sb.append(String.format("Exception thrown, %s: ", this.exceptionThrown.gqlStatusString()));
            }
            sb.append(this.message);
        }
    }
}

