/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.schema.IndexQuery;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.UTF8StringValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueCategory;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueTuple;
import org.neo4j.values.storable.Values;

public abstract class PropertyIndexQuery
implements IndexQuery {
    private final int propertyKeyId;

    public static AllEntriesPredicate allEntries() {
        return new AllEntriesPredicate();
    }

    public static ExistsPredicate exists(int propertyKeyId) {
        return new ExistsPredicate(propertyKeyId);
    }

    public static ExactPredicate exact(int propertyKeyId, Object value) {
        Value exactValue;
        Value value2 = exactValue = value instanceof Value ? (Value)value : Values.of((Object)value);
        if (AnyValue.isNaN((AnyValue)exactValue)) {
            return new IncomparableExactPredicate(propertyKeyId, exactValue);
        }
        return new ExactPredicate(propertyKeyId, exactValue);
    }

    public static RangePredicate<?> range(int propertyKeyId, Number from, boolean fromInclusive, Number to, boolean toInclusive) {
        return PropertyIndexQuery.range(propertyKeyId, from == null ? null : Values.numberValue((Number)from), fromInclusive, to == null ? null : Values.numberValue((Number)to), toInclusive);
    }

    public static RangePredicate<?> range(int propertyKeyId, String from, boolean fromInclusive, String to, boolean toInclusive) {
        return new TextRangePredicate(propertyKeyId, from == null ? null : Values.stringValue((String)from), fromInclusive, to == null ? null : Values.stringValue((String)to), toInclusive);
    }

    public static <VALUE extends Value> RangePredicate<?> range(int propertyKeyId, VALUE from, boolean fromInclusive, VALUE to, boolean toInclusive) {
        if (from == null && to == null) {
            throw new IllegalArgumentException("Cannot create RangePredicate without at least one bound");
        }
        ValueGroup valueGroup = Objects.requireNonNullElse(from, to).valueGroup();
        return switch (valueGroup) {
            case ValueGroup.NUMBER -> {
                if (AnyValue.hasNaNOperand(from, to)) {
                    yield new IncomparableRangePredicate<VALUE>(propertyKeyId, ValueGroup.NUMBER, from, fromInclusive, to, toInclusive);
                }
                yield new NumberRangePredicate(propertyKeyId, (NumberValue)from, fromInclusive, (NumberValue)to, toInclusive);
            }
            case ValueGroup.TEXT -> new TextRangePredicate(propertyKeyId, (TextValue)from, fromInclusive, (TextValue)to, toInclusive);
            case ValueGroup.DURATION, ValueGroup.DURATION_ARRAY, ValueGroup.GEOMETRY, ValueGroup.GEOMETRY_ARRAY -> {
                if (fromInclusive && to == null) {
                    yield new RangePredicate<VALUE>(propertyKeyId, valueGroup, from, true, from, true);
                }
                if (toInclusive && from == null) {
                    yield new RangePredicate<VALUE>(propertyKeyId, valueGroup, to, true, to, true);
                }
                if (fromInclusive && toInclusive && from.equals(to)) {
                    yield new RangePredicate<VALUE>(propertyKeyId, valueGroup, from, true, to, true);
                }
                yield new IncomparableRangePredicate<VALUE>(propertyKeyId, valueGroup, from, fromInclusive, to, toInclusive);
            }
            default -> new RangePredicate<VALUE>(propertyKeyId, valueGroup, from, fromInclusive, to, toInclusive);
        };
    }

    public static BoundingBoxPredicate boundingBox(int propertyKeyId, PointValue from, PointValue to) {
        return new BoundingBoxPredicate(propertyKeyId, from, to);
    }

    public static BoundingBoxPredicate boundingBox(int propertyKeyId, PointValue from, PointValue to, boolean inclusive) {
        return new BoundingBoxPredicate(propertyKeyId, from, to, inclusive);
    }

    public static StringPrefixPredicate stringPrefix(int propertyKeyId, TextValue prefix) {
        return new StringPrefixPredicate(propertyKeyId, prefix);
    }

    public static StringContainsPredicate stringContains(int propertyKeyId, TextValue contains) {
        return new StringContainsPredicate(propertyKeyId, contains);
    }

    public static StringSuffixPredicate stringSuffix(int propertyKeyId, TextValue suffix) {
        return new StringSuffixPredicate(propertyKeyId, suffix);
    }

    public static FulltextSearchPredicate fulltextSearch(String query) {
        return new FulltextSearchPredicate(query);
    }

    public static FulltextSearchPredicate fulltextSearch(String query, String queryAnalyzer) {
        return new FulltextSearchPredicate(query, queryAnalyzer);
    }

    public static NearestNeighborsPredicate nearestNeighbors(int k, float[] query) {
        return new NearestNeighborsPredicate(k, query);
    }

    public static ValueTuple asValueTuple(ExactPredicate ... query) {
        Value[] values = new Value[query.length];
        for (int i = 0; i < query.length; ++i) {
            values[i] = query[i].value();
        }
        return ValueTuple.of((Value[])values);
    }

    protected PropertyIndexQuery(int propertyKeyId) {
        this.propertyKeyId = propertyKeyId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyIndexQuery that = (PropertyIndexQuery)o;
        return this.propertyKeyId == that.propertyKeyId;
    }

    public int hashCode() {
        return this.propertyKeyId + this.getClass().hashCode();
    }

    public final String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public final int propertyKeyId() {
        return this.propertyKeyId;
    }

    public abstract boolean acceptsValue(Value var1);

    public boolean acceptsValueAt(PropertyCursor property) {
        return this.acceptsValue(property.propertyValue());
    }

    public abstract ValueGroup valueGroup();

    public ValueCategory valueCategory() {
        return this.valueGroup().category();
    }

    public static final class AllEntriesPredicate
    extends PropertyIndexQuery {
        private AllEntriesPredicate() {
            super(-1);
        }

        @Override
        public boolean acceptsValue(Value value) {
            return value != null && value != Values.NO_VALUE;
        }

        @Override
        public ValueGroup valueGroup() {
            return ValueGroup.UNKNOWN;
        }

        public IndexQuery.IndexQueryType type() {
            return IndexQuery.IndexQueryType.ALL_ENTRIES;
        }
    }

    public static final class ExistsPredicate
    extends PropertyIndexQuery {
        private ExistsPredicate(int propertyKeyId) {
            super(propertyKeyId);
        }

        public IndexQuery.IndexQueryType type() {
            return IndexQuery.IndexQueryType.EXISTS;
        }

        @Override
        public boolean acceptsValue(Value value) {
            return value != null && value != Values.NO_VALUE;
        }

        @Override
        public boolean acceptsValueAt(PropertyCursor property) {
            return true;
        }

        @Override
        public ValueGroup valueGroup() {
            return ValueGroup.UNKNOWN;
        }
    }

    public static class IncomparableExactPredicate
    extends ExactPredicate {
        private IncomparableExactPredicate(int propertyKeyId, Value value) {
            super(propertyKeyId, value);
        }

        @Override
        public boolean acceptsValue(Value value) {
            return false;
        }
    }

    public static class ExactPredicate
    extends PropertyIndexQuery {
        private final Value exactValue;

        private ExactPredicate(int propertyKeyId, Value value) {
            super(propertyKeyId);
            this.exactValue = value;
        }

        public IndexQuery.IndexQueryType type() {
            return IndexQuery.IndexQueryType.EXACT;
        }

        @Override
        public boolean acceptsValue(Value value) {
            return this.exactValue.equals(value);
        }

        @Override
        public ValueGroup valueGroup() {
            return this.exactValue.valueGroup();
        }

        public Value value() {
            return this.exactValue;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ExactPredicate that = (ExactPredicate)o;
            return Objects.equals(this.exactValue, that.exactValue);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.exactValue);
        }
    }

    public static class RangePredicate<T extends Value>
    extends PropertyIndexQuery {
        protected final T from;
        protected final boolean fromInclusive;
        protected final T to;
        protected final boolean toInclusive;
        protected final ValueGroup valueGroup;

        private RangePredicate(int propertyKeyId, ValueGroup valueGroup, T from, boolean fromInclusive, T to, boolean toInclusive) {
            super(propertyKeyId);
            this.valueGroup = valueGroup;
            this.from = from;
            this.fromInclusive = fromInclusive;
            this.to = to;
            this.toInclusive = toInclusive;
        }

        public IndexQuery.IndexQueryType type() {
            return IndexQuery.IndexQueryType.RANGE;
        }

        @Override
        public boolean acceptsValue(Value value) {
            int compare;
            if (value == null || value == Values.NO_VALUE || value.valueGroup() != this.valueGroup) {
                return false;
            }
            if (this.from != null && ((compare = Values.COMPARATOR.compare(value, this.from)) < 0 || !this.fromInclusive && compare == 0)) {
                return false;
            }
            if (this.to != null) {
                compare = Values.COMPARATOR.compare(value, this.to);
                return compare <= 0 && (this.toInclusive || compare != 0);
            }
            return true;
        }

        @Override
        public ValueGroup valueGroup() {
            return this.valueGroup;
        }

        public Value fromValue() {
            return this.from == null ? Values.NO_VALUE : this.from;
        }

        public Value toValue() {
            return this.to == null ? Values.NO_VALUE : this.to;
        }

        public boolean fromInclusive() {
            return this.fromInclusive;
        }

        public boolean toInclusive() {
            return this.toInclusive;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RangePredicate that = (RangePredicate)o;
            return this.fromInclusive == that.fromInclusive && this.toInclusive == that.toInclusive && Objects.equals(this.from, that.from) && Objects.equals(this.to, that.to) && this.valueGroup == that.valueGroup;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.from, this.fromInclusive, this.to, this.toInclusive, this.valueGroup);
        }
    }

    public static final class TextRangePredicate
    extends RangePredicate<TextValue> {
        private TextRangePredicate(int propertyKeyId, TextValue from, boolean fromInclusive, TextValue to, boolean toInclusive) {
            super(propertyKeyId, ValueGroup.TEXT, from, fromInclusive, to, toInclusive);
        }

        public String from() {
            return this.from == null ? null : ((TextValue)this.from).stringValue();
        }

        public String to() {
            return this.to == null ? null : ((TextValue)this.to).stringValue();
        }
    }

    public static class IncomparableRangePredicate<T extends Value>
    extends RangePredicate<Value> {
        private IncomparableRangePredicate(int propertyKeyId, ValueGroup valueGroup, T from, boolean fromInclusive, T to, boolean toInclusive) {
            super(propertyKeyId, valueGroup, from, fromInclusive, to, toInclusive);
        }

        @Override
        public boolean acceptsValue(Value value) {
            return false;
        }
    }

    public static final class NumberRangePredicate
    extends RangePredicate<NumberValue> {
        private NumberRangePredicate(int propertyKeyId, NumberValue from, boolean fromInclusive, NumberValue to, boolean toInclusive) {
            super(propertyKeyId, ValueGroup.NUMBER, from, fromInclusive, (NumberValue)Objects.requireNonNullElse(to, Values.doubleValue((double)Double.POSITIVE_INFINITY)), to == null || toInclusive);
        }

        public Number from() {
            return this.from == null ? (Number)null : (Number)((NumberValue)this.from).asObject();
        }

        public Number to() {
            return ((NumberValue)this.to).asObject();
        }
    }

    public static final class BoundingBoxPredicate
    extends PropertyIndexQuery {
        private final CoordinateReferenceSystem crs;
        private final PointValue from;
        private final PointValue to;
        private final boolean inclusive;

        private BoundingBoxPredicate(int propertyKeyId, PointValue from, PointValue to, boolean inclusive) {
            super(propertyKeyId);
            Objects.requireNonNull(from);
            Objects.requireNonNull(to);
            this.crs = from.getCoordinateReferenceSystem();
            this.from = from;
            this.to = to;
            this.inclusive = inclusive;
        }

        private BoundingBoxPredicate(int propertyKeyId, PointValue from, PointValue to) {
            this(propertyKeyId, from, to, true);
        }

        @Override
        public boolean acceptsValue(Value value) {
            if (!(value instanceof PointValue)) {
                return false;
            }
            PointValue point = (PointValue)value;
            CoordinateReferenceSystem crs = point.getCoordinateReferenceSystem();
            if (!crs.equals((Object)this.crs)) {
                return false;
            }
            return crs.getCalculator().withinBBox(point, this.from, this.to, this.inclusive);
        }

        @Override
        public ValueGroup valueGroup() {
            return ValueGroup.GEOMETRY;
        }

        public CoordinateReferenceSystem crs() {
            return this.crs;
        }

        public PointValue from() {
            return this.from;
        }

        public PointValue to() {
            return this.to;
        }

        public IndexQuery.IndexQueryType type() {
            return IndexQuery.IndexQueryType.BOUNDING_BOX;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            BoundingBoxPredicate that = (BoundingBoxPredicate)o;
            return this.inclusive == that.inclusive && this.crs == that.crs && Objects.equals(this.from, that.from) && Objects.equals(this.to, that.to);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.crs, this.from, this.to, this.inclusive);
        }
    }

    public static final class StringPrefixPredicate
    extends StringPredicate {
        private final TextValue prefix;

        private StringPrefixPredicate(int propertyKeyId, TextValue prefix) {
            super(propertyKeyId);
            this.prefix = StringPrefixPredicate.asUTF8StringValue(prefix);
        }

        public IndexQuery.IndexQueryType type() {
            return IndexQuery.IndexQueryType.STRING_PREFIX;
        }

        @Override
        public boolean acceptsValue(Value value) {
            return Values.isTextValue((Object)value) && ((TextValue)value).startsWith(this.prefix);
        }

        public TextValue prefix() {
            return this.prefix;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            StringPrefixPredicate that = (StringPrefixPredicate)o;
            return Objects.equals(this.prefix, that.prefix);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.prefix);
        }
    }

    public static final class StringContainsPredicate
    extends StringPredicate {
        private final TextValue contains;

        private StringContainsPredicate(int propertyKeyId, TextValue contains) {
            super(propertyKeyId);
            this.contains = StringContainsPredicate.asUTF8StringValue(contains);
        }

        public IndexQuery.IndexQueryType type() {
            return IndexQuery.IndexQueryType.STRING_CONTAINS;
        }

        @Override
        public boolean acceptsValue(Value value) {
            return Values.isTextValue((Object)value) && ((TextValue)value).contains(this.contains);
        }

        public TextValue contains() {
            return this.contains;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            StringContainsPredicate that = (StringContainsPredicate)o;
            return Objects.equals(this.contains, that.contains);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.contains);
        }
    }

    public static final class StringSuffixPredicate
    extends StringPredicate {
        private final TextValue suffix;

        private StringSuffixPredicate(int propertyKeyId, TextValue suffix) {
            super(propertyKeyId);
            this.suffix = StringSuffixPredicate.asUTF8StringValue(suffix);
        }

        public IndexQuery.IndexQueryType type() {
            return IndexQuery.IndexQueryType.STRING_SUFFIX;
        }

        @Override
        public boolean acceptsValue(Value value) {
            return Values.isTextValue((Object)value) && ((TextValue)value).endsWith(this.suffix);
        }

        public TextValue suffix() {
            return this.suffix;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            StringSuffixPredicate that = (StringSuffixPredicate)o;
            return Objects.equals(this.suffix, that.suffix);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.suffix);
        }
    }

    public static final class FulltextSearchPredicate
    extends StringPredicate {
        private final String query;
        private final String queryAnalyzer;

        private FulltextSearchPredicate(String query) {
            this(query, null);
        }

        private FulltextSearchPredicate(String query, String queryAnalyzer) {
            super(-1);
            this.query = query;
            this.queryAnalyzer = queryAnalyzer;
        }

        public IndexQuery.IndexQueryType type() {
            return IndexQuery.IndexQueryType.FULLTEXT_SEARCH;
        }

        @Override
        public boolean acceptsValue(Value value) {
            throw new UnsupportedOperationException("Fulltext search predicates do not know how to evaluate themselves.");
        }

        public String query() {
            return this.query;
        }

        public String queryAnalyzer() {
            return this.queryAnalyzer;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FulltextSearchPredicate that = (FulltextSearchPredicate)o;
            return Objects.equals(this.query, that.query) && Objects.equals(this.queryAnalyzer, that.queryAnalyzer);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.query, this.queryAnalyzer);
        }
    }

    public static final class NearestNeighborsPredicate
    extends PropertyIndexQuery {
        private final int k;
        private final float[] query;

        private NearestNeighborsPredicate(int k, float ... query) {
            super(-1);
            this.k = k;
            this.query = query;
        }

        @Override
        public boolean acceptsValue(Value value) {
            throw new UnsupportedOperationException("Nearest neighbour predicates do not know how to evaluate themselves.");
        }

        @Override
        public ValueGroup valueGroup() {
            return ValueGroup.NUMBER_ARRAY;
        }

        public IndexQuery.IndexQueryType type() {
            return IndexQuery.IndexQueryType.NEAREST_NEIGHBORS;
        }

        public int numberOfNeighbors() {
            return this.k;
        }

        public float[] query() {
            return this.query;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            NearestNeighborsPredicate that = (NearestNeighborsPredicate)o;
            return this.k == that.k && Arrays.equals(this.query, that.query);
        }

        @Override
        public int hashCode() {
            int result = Objects.hash(super.hashCode(), this.k);
            result = 31 * result + Arrays.hashCode(this.query);
            return result;
        }
    }

    public static abstract class StringPredicate
    extends PropertyIndexQuery {
        private StringPredicate(int propertyKeyId) {
            super(propertyKeyId);
        }

        @Override
        public ValueGroup valueGroup() {
            return ValueGroup.TEXT;
        }

        protected static TextValue asUTF8StringValue(TextValue in) {
            if (in instanceof UTF8StringValue) {
                return in;
            }
            return Values.utf8Value((byte[])in.stringValue().getBytes(StandardCharsets.UTF_8));
        }
    }
}

