/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

import java.util.Arrays;
import java.util.Objects;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.UpdateMode;

public final class TokenIndexEntryUpdate
extends IndexEntryUpdate {
    private final int[] removed;
    private final int[] added;

    TokenIndexEntryUpdate(long entityId, IndexDescriptor indexKey, int[] removed, int[] added) {
        super(entityId, indexKey, UpdateMode.CHANGED);
        this.removed = Objects.requireNonNull(removed);
        this.added = Objects.requireNonNull(added);
    }

    public int[] added() {
        return this.added;
    }

    public int[] removed() {
        return this.removed;
    }

    @Override
    public long roughSizeOfUpdate() {
        return HeapEstimator.sizeOf((int[])this.added) + HeapEstimator.sizeOf((int[])this.removed);
    }

    @Override
    protected boolean valueEquals(IndexEntryUpdate o) {
        if (!(o instanceof TokenIndexEntryUpdate)) {
            return false;
        }
        TokenIndexEntryUpdate that = (TokenIndexEntryUpdate)o;
        if (!Arrays.equals(this.removed, that.removed)) {
            return false;
        }
        return Arrays.equals(this.added, that.added);
    }

    @Override
    protected int valueHash() {
        int result = Arrays.hashCode(this.removed);
        result = 31 * result + Arrays.hashCode(this.added);
        return result;
    }

    @Override
    protected String valueToString() {
        return String.format("removed=%s, added=%s", Arrays.toString(this.removed), Arrays.toString(this.added));
    }

    @Override
    public IndexEntryUpdate withEntityId(long entityId) {
        return TokenIndexEntryUpdate.tokenChange(entityId, this.indexKey(), this.removed, this.added);
    }

    public static TokenIndexEntryUpdate tokenChange(long entityId, IndexDescriptor indexKey, int[] removed, int[] added) {
        return new TokenIndexEntryUpdate(entityId, indexKey, removed, added);
    }
}

