/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.PopulationProgress;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryConflictHandler;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.MinimalIndexAccessor;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.kernel.impl.api.index.SwallowingIndexUpdater;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.values.storable.Value;

public interface IndexPopulator
extends MinimalIndexAccessor {
    public static final IndexPopulator EMPTY = new Adapter();

    public void create() throws IOException;

    public void add(Collection<? extends IndexEntryUpdate> var1, CursorContext var2) throws IndexEntryConflictException;

    public IndexUpdater newPopulatingUpdater(CursorContext var1);

    public void close(boolean var1, CursorContext var2);

    public void markAsFailed(String var1);

    public void includeSample(IndexEntryUpdate var1);

    public IndexSample sample(CursorContext var1);

    default public PopulationProgress progress(PopulationProgress scanProgress) {
        return scanProgress;
    }

    default public void scanCompleted(PhaseTracker phaseTracker, PopulationWorkScheduler populationWorkScheduler, CursorContext cursorContext) throws IndexEntryConflictException {
        this.scanCompleted(phaseTracker, populationWorkScheduler, IndexEntryConflictHandler.THROW, cursorContext);
    }

    default public void scanCompleted(PhaseTracker phaseTracker, PopulationWorkScheduler populationWorkScheduler, IndexEntryConflictHandler conflictHandler, CursorContext cursorContext) throws IndexEntryConflictException {
    }

    @FunctionalInterface
    public static interface PopulationWorkScheduler {
        public <T> JobHandle<T> schedule(JobDescriptionSupplier var1, Callable<T> var2);
    }

    public static class Adapter
    implements IndexPopulator {
        @Override
        public void create() {
        }

        @Override
        public void drop() {
        }

        @Override
        public ResourceIterator<Path> snapshotFiles() {
            return Iterators.emptyResourceIterator();
        }

        @Override
        public void add(Collection<? extends IndexEntryUpdate> updates, CursorContext cursorContext) {
        }

        @Override
        public IndexUpdater newPopulatingUpdater(CursorContext cursorContext) {
            return SwallowingIndexUpdater.INSTANCE;
        }

        @Override
        public void scanCompleted(PhaseTracker phaseTracker, PopulationWorkScheduler jobScheduler, IndexEntryConflictHandler conflictHandler, CursorContext cursorContext) {
        }

        @Override
        public void close(boolean populationCompletedSuccessfully, CursorContext cursorContext) {
        }

        @Override
        public void markAsFailed(String failure) {
        }

        @Override
        public void includeSample(IndexEntryUpdate update) {
        }

        @Override
        public IndexSample sample(CursorContext cursorContext) {
            return new IndexSample();
        }
    }

    public static class Delegating
    implements IndexPopulator {
        private final IndexPopulator delegate;

        public Delegating(IndexPopulator delegate) {
            this.delegate = delegate;
        }

        @Override
        public void create() throws IOException {
            this.delegate.create();
        }

        @Override
        public void drop() {
            this.delegate.drop();
        }

        @Override
        public ResourceIterator<Path> snapshotFiles() throws IOException {
            return this.delegate.snapshotFiles();
        }

        @Override
        public void add(Collection<? extends IndexEntryUpdate> updates, CursorContext cursorContext) throws IndexEntryConflictException {
            this.delegate.add(updates, cursorContext);
        }

        @Override
        public IndexUpdater newPopulatingUpdater(CursorContext cursorContext) {
            return this.delegate.newPopulatingUpdater(cursorContext);
        }

        @Override
        public void close(boolean populationCompletedSuccessfully, CursorContext cursorContext) {
            this.delegate.close(populationCompletedSuccessfully, cursorContext);
        }

        @Override
        public void markAsFailed(String failure) {
            this.delegate.markAsFailed(failure);
        }

        @Override
        public void includeSample(IndexEntryUpdate update) {
            this.delegate.includeSample(update);
        }

        @Override
        public IndexSample sample(CursorContext cursorContext) {
            return this.delegate.sample(cursorContext);
        }

        @Override
        public PopulationProgress progress(PopulationProgress scanProgress) {
            return this.delegate.progress(scanProgress);
        }

        @Override
        public void scanCompleted(PhaseTracker phaseTracker, PopulationWorkScheduler jobScheduler, IndexEntryConflictHandler conflictHandler, CursorContext cursorContext) throws IndexEntryConflictException {
            this.delegate.scanCompleted(phaseTracker, jobScheduler, conflictHandler, cursorContext);
        }

        @Override
        public Map<String, Value> indexConfig() {
            return this.delegate.indexConfig();
        }
    }

    @FunctionalInterface
    public static interface JobDescriptionSupplier {
        public String getJobDescription(String var1);
    }
}

