/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api;

import org.neo4j.lang.AutoCloseablePlus;
import org.neo4j.lang.CloseListener;

public abstract class DefaultCloseListenable
implements AutoCloseablePlus {
    protected CloseListener closeListener;
    private int token = -1;

    public final void setCloseListener(CloseListener closeListener) {
        this.closeListener = closeListener;
    }

    public final CloseListener getCloseListener() {
        return this.closeListener;
    }

    public final void close() {
        this.closeInternal();
        CloseListener listener = this.closeListener;
        if (listener != null) {
            listener.onClosed((AutoCloseablePlus)this);
        }
    }

    public final void setToken(int token) {
        this.token = token;
    }

    public final int getToken() {
        return this.token;
    }

    public static DefaultCloseListenable wrap(final AutoCloseable c) {
        return new DefaultCloseListenable(){
            private boolean closed;

            public void closeInternal() {
                try {
                    c.close();
                    this.closed = true;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public boolean isClosed() {
                return this.closed;
            }
        };
    }
}

