/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.security;

import java.net.InetAddress;
import java.net.URI;
import java.util.function.IntPredicate;
import java.util.function.Supplier;
import org.neo4j.internal.kernel.api.LabelsSupplier;
import org.neo4j.internal.kernel.api.RelTypeSupplier;
import org.neo4j.internal.kernel.api.TokenSet;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.PermissionState;
import org.neo4j.internal.kernel.api.security.PrivilegeAction;
import org.neo4j.internal.kernel.api.security.SelectedPropertiesProvider;
import org.neo4j.storageengine.api.PropertySelection;

public enum StaticAccessMode implements AccessMode
{
    ACCESS(false, false, false, false, false),
    CREDENTIALS_EXPIRED(false, false, false, false, false),
    READ(true, false, false, false, false),
    WRITE_ONLY(false, true, false, false, false),
    WRITE(true, true, false, false, false),
    TOKEN_WRITE(true, true, true, false, false),
    SCHEMA(true, true, true, true, false),
    FULL(true, true, true, true, true);

    private final boolean read;
    private final boolean write;
    private final boolean token;
    private final boolean schema;
    private final boolean procedureBoost;

    private StaticAccessMode(boolean read, boolean write, boolean token, boolean schema, boolean procedureBoost) {
        this.read = read;
        this.write = write;
        this.token = token;
        this.schema = schema;
        this.procedureBoost = procedureBoost;
    }

    @Override
    public boolean allowsWrites() {
        return this.write;
    }

    @Override
    public PermissionState allowsTokenCreates(PrivilegeAction action) {
        return PermissionState.fromAllowList(this.token);
    }

    @Override
    public boolean allowsSchemaWrites() {
        return this.schema;
    }

    @Override
    public PermissionState allowsSchemaWrites(PrivilegeAction action) {
        return PermissionState.fromAllowList(this.schema);
    }

    @Override
    public boolean allowsShowIndex() {
        return this.schema;
    }

    @Override
    public boolean allowsShowConstraint() {
        return this.schema;
    }

    @Override
    public boolean allowsTraverseAllLabels() {
        return this.read;
    }

    @Override
    public boolean allowsTraverseAllNodesWithLabel(int label) {
        return this.read;
    }

    @Override
    public boolean disallowsTraverseLabel(int label) {
        return false;
    }

    @Override
    public boolean allowsTraverseNode(int ... labels) {
        return this.read;
    }

    @Override
    public boolean hasApplicableTraverseNodeAllowPropertyRules(int label) {
        return this.read;
    }

    @Override
    public boolean allowsTraverseNode(LabelsSupplier labels, SelectedPropertiesProvider selectedPropertiesProvider) {
        return this.read;
    }

    @Override
    public boolean allowsTraverseAllRelTypes() {
        return this.read;
    }

    @Override
    public boolean allowsTraverseRelType(int relType) {
        return this.read;
    }

    @Override
    public boolean allowsTraverseAllRelsWithType(int relType) {
        return this.read;
    }

    @Override
    public boolean disallowsTraverseRelType(int relType) {
        return false;
    }

    @Override
    public boolean hasApplicableTraverseRelAllowPropertyRules(int type) {
        return this.read;
    }

    @Override
    public boolean allowsTraverseRelationship(int type, SelectedPropertiesProvider propertyProviderSupplier) {
        return this.read;
    }

    @Override
    public boolean allowsReadNodeProperties(LabelsSupplier labels, int[] propertyKeys, Supplier<SelectedPropertiesProvider> propertyProvider) {
        return this.read;
    }

    @Override
    public IntPredicate allowedToReadNodeProperties(LabelsSupplier labels, Supplier<SelectedPropertiesProvider> propertyProvider, PropertySelection selection) {
        return key -> this.read;
    }

    @Override
    public boolean allowsTraverseAndReadAllMatchingNodeProperties(int[] labels, int[] propertyKeys) {
        return this.read;
    }

    @Override
    public boolean allowsTraverseAndReadAllMatchingRelProperties(int[] relTypes, int[] propertyKeys) {
        return this.read;
    }

    @Override
    public boolean allowsReadRelProperties(RelTypeSupplier relType, int[] propertyKeys, Supplier<SelectedPropertiesProvider> propertyProvider) {
        return this.read;
    }

    @Override
    public IntPredicate allowedToReadRelationshipProperties(RelTypeSupplier relType, Supplier<SelectedPropertiesProvider> propertyProvider, PropertySelection selection) {
        return key -> this.read;
    }

    @Override
    public boolean allowsSeePropertyKeyToken(int propertyKey) {
        return this.read;
    }

    @Override
    public PermissionState allowsExecuteProcedure(int procedureId) {
        return PermissionState.EXPLICIT_GRANT;
    }

    @Override
    public PermissionState allowExecuteAdminProcedures() {
        return PermissionState.EXPLICIT_GRANT;
    }

    @Override
    public PermissionState shouldBoostProcedure(int procedureId) {
        return PermissionState.fromAllowList(this.procedureBoost);
    }

    @Override
    public PermissionState allowsExecuteFunction(int id) {
        return PermissionState.EXPLICIT_GRANT;
    }

    @Override
    public PermissionState shouldBoostFunction(int id) {
        return PermissionState.fromAllowList(this.procedureBoost);
    }

    @Override
    public PermissionState allowsExecuteAggregatingFunction(int id) {
        return PermissionState.EXPLICIT_GRANT;
    }

    @Override
    public PermissionState shouldBoostAggregatingFunction(int id) {
        return PermissionState.fromAllowList(this.procedureBoost);
    }

    @Override
    public PermissionState allowsShowSetting(String setting) {
        return PermissionState.EXPLICIT_GRANT;
    }

    @Override
    public boolean allowsSetLabel(int labelId) {
        return this.write;
    }

    @Override
    public boolean allowsRemoveLabel(int labelId) {
        return this.write;
    }

    @Override
    public boolean allowsCreateNode(int[] labelIds) {
        return this.write;
    }

    @Override
    public boolean allowsDeleteNode(Supplier<TokenSet> labelSupplier) {
        return this.write;
    }

    @Override
    public boolean allowsCreateRelationship(int relType) {
        return this.write;
    }

    @Override
    public boolean allowsDeleteRelationship(int relType) {
        return this.write;
    }

    @Override
    public boolean allowsSetProperty(LabelsSupplier labels, int propertyKey) {
        return this.write;
    }

    @Override
    public boolean allowsSetProperty(RelTypeSupplier relType, int propertyKey) {
        return this.write;
    }

    @Override
    public PermissionState allowsLoadAllData() {
        return PermissionState.fromAllowList(this.read);
    }

    @Override
    public PermissionState allowsLoadUri(URI uri, InetAddress inetAddress) {
        return PermissionState.fromAllowList(this.read);
    }
}

