/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.Collections;
import java.util.Map;
import org.neo4j.values.storable.Value;

public interface IndexConfigProvider {
    default public Map<String, Value> indexConfig() {
        return Collections.emptyMap();
    }

    public static void putAllNoOverwrite(Map<String, Value> target, Map<String, Value> source) {
        for (Map.Entry<String, Value> partEntry : source.entrySet()) {
            String key = partEntry.getKey();
            Value value = partEntry.getValue();
            if (target.containsKey(key)) {
                throw new IllegalStateException(String.format("Adding config would overwrite existing value: key=%s, newValue=%s, oldValue=%s", key, value, target.get(key)));
            }
            target.put(key, value);
        }
    }
}

