/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.TokenIndexEntryUpdate;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;

public interface IndexUpdater
extends AutoCloseable {
    public void process(IndexEntryUpdate var1) throws IndexEntryConflictException;

    default public void yield() {
    }

    default public ValueIndexEntryUpdate asValueUpdate(IndexEntryUpdate update) {
        if (update instanceof ValueIndexEntryUpdate) {
            ValueIndexEntryUpdate valueUpdate = (ValueIndexEntryUpdate)update;
            return valueUpdate;
        }
        throw new UnsupportedOperationException("Tried to process " + String.valueOf(update) + " with " + this.getClass().getSimpleName() + ", but this is not supported.");
    }

    default public TokenIndexEntryUpdate asTokenUpdate(IndexEntryUpdate update) {
        if (update instanceof TokenIndexEntryUpdate) {
            TokenIndexEntryUpdate tokenUpdate = (TokenIndexEntryUpdate)update;
            return tokenUpdate;
        }
        throw new UnsupportedOperationException("Tried to process " + String.valueOf(update) + " with " + this.getClass().getSimpleName() + ", but this is not supported.");
    }

    @Override
    public void close() throws IndexEntryConflictException;
}

