/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.exceptions.schema;

import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.token.api.TokenType;

public class IllegalTokenNameException
extends SchemaKernelException {
    private IllegalTokenNameException(ErrorGqlStatusObject gqlStatusObject, String tokenName) {
        super(gqlStatusObject, (Status)Status.Schema.TokenNameError, String.format("%s is not a valid token name. Token names cannot be empty or contain any null-bytes.", tokenName != null ? "'" + tokenName + "'" : "Null"));
    }

    public static IllegalTokenNameException invalidTokenName(String tokenName, TokenType type) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42I11).withParam(GqlParams.StringParam.tokenType, type.getName()).withParam(GqlParams.StringParam.input, tokenName).build();
        return new IllegalTokenNameException(gql, tokenName);
    }
}

