/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import org.neo4j.unsafe.impl.internal.dragons.UnsafeUtil;

public final class OffHeapPageLock {
    private static final long CNT_BITS = 17L;
    private static final long BITS_IN_LONG = 64L;
    private static final long EXL_LOCK_BITS = 1L;
    private static final long FLS_LOCK_BITS = 1L;
    private static final long MOD_BITS = 1L;
    private static final long SEQ_BITS = 44L;
    private static final long FLS_MASK = Long.MIN_VALUE;
    private static final long EXL_MASK = 0x4000000000000000L;
    private static final long MOD_MASK = 0x2000000000000000L;
    private static final long CNT_MASK = 0x1FFFF00000000000L;
    private static final long SEQ_MASK = 0xFFFFFFFFFFFL;
    private static final long CNT_UNIT = 0x100000000000L;
    private static final long SEQ_IMSK = -17592186044416L;
    private static final long CHK_MASK = 0x5FFFFFFFFFFFFFFFL;
    private static final long FAE_MASK = -4611686018427387904L;
    private static final long UNL_MASK = -2305860601399738368L;

    private OffHeapPageLock() {
    }

    private static long getState(long address) {
        return UnsafeUtil.getLongVolatile((long)address);
    }

    private static boolean compareAndSetState(long address, long expect, long update) {
        return UnsafeUtil.compareAndSwapLong(null, (long)address, (long)expect, (long)update);
    }

    private static void unconditionallySetState(long address, long update) {
        UnsafeUtil.putLongVolatile((long)address, (long)update);
    }

    public static long initialLockWordWithExclusiveLock() {
        return 0x4000000000000000L;
    }

    public static long tryOptimisticReadLock(long address) {
        return OffHeapPageLock.getState(address) & 0xFFFFFFFFFFFL;
    }

    public static boolean validateReadLock(long address, long stamp) {
        UnsafeUtil.loadFence();
        return (OffHeapPageLock.getState(address) & 0x5FFFFFFFFFFFFFFFL) == stamp;
    }

    public static boolean isModified(long address) {
        return (OffHeapPageLock.getState(address) & 0x2000000000000000L) == 0x2000000000000000L;
    }

    public static boolean isExclusivelyLocked(long address) {
        return (OffHeapPageLock.getState(address) & 0x4000000000000000L) == 0x4000000000000000L;
    }

    public static boolean tryWriteLock(long address) {
        long n;
        long s;
        do {
            boolean writeCountOverflow;
            boolean unwritablyLocked = ((s = OffHeapPageLock.getState(address)) & 0x4000000000000000L) != 0L;
            boolean bl = writeCountOverflow = (s & 0x1FFFF00000000000L) == 0x1FFFF00000000000L;
            if (!(unwritablyLocked | writeCountOverflow)) continue;
            return OffHeapPageLock.failWriteLock(s, writeCountOverflow);
        } while (!OffHeapPageLock.compareAndSetState(address, s, n = s + 0x100000000000L | 0x2000000000000000L));
        UnsafeUtil.storeFence();
        return true;
    }

    private static boolean failWriteLock(long s, boolean writeCountOverflow) {
        if (writeCountOverflow) {
            OffHeapPageLock.throwWriteLockOverflow(s);
        }
        return false;
    }

    private static void throwWriteLockOverflow(long s) {
        throw new IllegalMonitorStateException("Write lock counter overflow: " + OffHeapPageLock.describeState(s));
    }

    public static void unlockWrite(long address) {
        long n;
        long s;
        do {
            if (((s = OffHeapPageLock.getState(address)) & 0x1FFFF00000000000L) != 0L) continue;
            OffHeapPageLock.throwUnmatchedUnlockWrite(s);
        } while (!OffHeapPageLock.compareAndSetState(address, s, n = OffHeapPageLock.nextSeq(s) - 0x100000000000L));
    }

    private static void throwUnmatchedUnlockWrite(long s) {
        throw new IllegalMonitorStateException("Unmatched unlockWrite: " + OffHeapPageLock.describeState(s));
    }

    private static long nextSeq(long s) {
        return (s & 0xFFFFF00000000000L) + (s + 1L & 0xFFFFFFFFFFFL);
    }

    public static long unlockWriteAndTryTakeFlushLock(long address) {
        long r;
        long n;
        long s;
        do {
            r = 0L;
            s = OffHeapPageLock.getState(address);
            if ((s & 0x1FFFF00000000000L) == 0L) {
                OffHeapPageLock.throwUnmatchedUnlockWrite(s);
            }
            if (((n = OffHeapPageLock.nextSeq(s) - 0x100000000000L) & 0xC000000000000000L) != 0L) continue;
            r = n += Long.MIN_VALUE;
        } while (!OffHeapPageLock.compareAndSetState(address, s, n));
        UnsafeUtil.storeFence();
        return r;
    }

    public static boolean tryExclusiveLock(long address) {
        long s = OffHeapPageLock.getState(address);
        boolean res = (s & 0xDFFFF00000000000L) == 0L && OffHeapPageLock.compareAndSetState(address, s, s + 0x4000000000000000L);
        UnsafeUtil.storeFence();
        return res;
    }

    public static long unlockExclusive(long address) {
        long s = OffHeapPageLock.initiateExclusiveLockRelease(address);
        long n = OffHeapPageLock.nextSeq(s) - 0x4000000000000000L;
        OffHeapPageLock.unconditionallySetState(address, n);
        return n;
    }

    public static void unlockExclusiveAndTakeWriteLock(long address) {
        long s = OffHeapPageLock.initiateExclusiveLockRelease(address);
        long n = OffHeapPageLock.nextSeq(s) - 0x4000000000000000L + 0x100000000000L | 0x2000000000000000L;
        OffHeapPageLock.unconditionallySetState(address, n);
    }

    private static long initiateExclusiveLockRelease(long address) {
        long s = OffHeapPageLock.getState(address);
        if ((s & 0x4000000000000000L) != 0x4000000000000000L) {
            OffHeapPageLock.throwUnmatchedUnlockExclusive(s);
        }
        return s;
    }

    private static void throwUnmatchedUnlockExclusive(long s) {
        throw new IllegalMonitorStateException("Unmatched unlockExclusive: " + OffHeapPageLock.describeState(s));
    }

    public static void explicitlyMarkPageUnmodifiedUnderExclusiveLock(long address) {
        long s = OffHeapPageLock.getState(address);
        if ((s & 0x4000000000000000L) != 0x4000000000000000L) {
            throw new IllegalStateException("Page must be exclusively locked to explicitly lower modified bit");
        }
        OffHeapPageLock.unconditionallySetState(address, s &= 0xDFFFFFFFFFFFFFFFL);
    }

    public static long tryFlushLock(long address) {
        long s = OffHeapPageLock.getState(address);
        if ((s & 0xC000000000000000L) == 0L) {
            long n = s + Long.MIN_VALUE;
            boolean res = OffHeapPageLock.compareAndSetState(address, s, n);
            UnsafeUtil.storeFence();
            return res ? n : 0L;
        }
        return 0L;
    }

    public static void unlockFlush(long address, long stamp, boolean success) {
        long n;
        long s;
        do {
            if (((s = OffHeapPageLock.getState(address)) & Long.MIN_VALUE) != Long.MIN_VALUE) {
                OffHeapPageLock.throwUnmatchedUnlockFlush(s);
            }
            n = s - Long.MIN_VALUE;
            if (!success || (s & 0x5FFFFFFFFFFFFFFFL) != (stamp & 0xFFFFFFFFFFFL)) continue;
            n &= 0xDFFFFFFFFFFFFFFFL;
        } while (!OffHeapPageLock.compareAndSetState(address, s, n));
    }

    private static void throwUnmatchedUnlockFlush(long s) {
        throw new IllegalMonitorStateException("Unmatched unlockFlush: " + OffHeapPageLock.describeState(s));
    }

    private static String describeState(long s) {
        long flush = s >>> 63;
        long excl = (s & 0x4000000000000000L) >>> 62;
        long mod = (s & 0x2000000000000000L) >>> 61;
        long cnt = (s & 0x1FFFF00000000000L) >> 44;
        long seq = s & 0xFFFFFFFFFFFL;
        return "OffHeapPageLock[Flush: " + flush + ", Excl: " + excl + ", Mod: " + mod + ", Ws: " + cnt + ", S: " + seq + "]";
    }

    static String toString(long address) {
        return OffHeapPageLock.describeState(OffHeapPageLock.getState(address));
    }
}

