/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import java.util.Objects;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PageCursorUtil;

class Root {
    private final long rootId;
    private final long rootGeneration;

    Root(long rootId, long rootGeneration) {
        this.rootId = rootId;
        this.rootGeneration = rootGeneration;
    }

    long goTo(PageCursor cursor) throws IOException {
        PageCursorUtil.goTo((PageCursor)cursor, (String)"root", (long)this.rootId);
        return this.rootGeneration;
    }

    long id() {
        return this.rootId;
    }

    long generation() {
        return this.rootGeneration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Root root = (Root)o;
        return this.rootId == root.rootId && this.rootGeneration == root.rootGeneration;
    }

    public int hashCode() {
        return Objects.hash(this.rootId, this.rootGeneration);
    }

    public String toString() {
        return String.format("Root[%d, gen:%d]", this.rootId, this.rootGeneration);
    }
}

