/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.neo4j.io.pagecache.PageCursor;

public class Header {
    public static final int OVERHEAD = 118;
    static final Writer CARRY_OVER_PREVIOUS_HEADER = (from, length, to) -> {
        int toOffset = to.getOffset();
        from.copyTo(from.getOffset(), to, toOffset, length);
        to.setOffset(toOffset + length);
    };

    private Header() {
    }

    static Writer replace(Consumer<PageCursor> writer) {
        return (from, length, to) -> writer.accept(to);
    }

    public static interface Writer {
        public void write(PageCursor var1, int var2, PageCursor var3);
    }

    public static class TreeCreationChecker
    implements Reader {
        private boolean wasCreated = true;

        @Override
        public void read(ByteBuffer headerBytes) {
            this.wasCreated = false;
        }

        public boolean wasCreated() {
            return this.wasCreated;
        }
    }

    public static interface Reader {
        public void read(ByteBuffer var1);
    }
}

