/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input.parquet;

import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import org.neo4j.batchimport.api.input.IdType;
import org.neo4j.internal.batchimport.input.parquet.EntityType;
import org.neo4j.internal.batchimport.input.parquet.ParquetColumnType;
import org.neo4j.internal.batchimport.input.parquet.ParquetLogicalColumnType;
import org.neo4j.values.storable.Value;

record ParquetColumn(String columnName, String propertyName, String groupName, ParquetLogicalColumnType logicalColumnType, ParquetColumnType columnType, boolean isArray, String rawConfiguration, Map<String, String> configuration) {
    static ParquetColumn from(String columnNameValue, EntityType knownEntityType) {
        String columnName = columnNameValue;
        boolean isArray = ParquetColumn.hasArrayDefinition(columnNameValue);
        columnNameValue = columnNameValue.replace("[]", "");
        EnclosureMatch groupNameMatch = ParquetColumn.extractGroupName(columnNameValue);
        EnclosureMatch configurationMatch = ParquetColumn.extractConfiguration(columnNameValue);
        columnNameValue = groupNameMatch.removeFrom(columnNameValue);
        columnNameValue = configurationMatch.adjustAfterRemovalOf(groupNameMatch).removeFrom(columnNameValue);
        String propertyName = ParquetColumn.extractPropertyName(columnNameValue);
        ParquetLogicalColumnType logicalColumnType = ParquetLogicalColumnType.resolve(ParquetColumn.extractLogicalColumnType(columnNameValue), knownEntityType);
        ParquetColumnType columnType = ParquetColumnType.resolve(ParquetColumn.extractColumnType(logicalColumnType, columnNameValue));
        String rawConfiguration = configurationMatch.getMatch();
        Map<String, String> configuration = ParquetColumn.parseConfiguration(rawConfiguration);
        return new ParquetColumn(columnName, propertyName, groupNameMatch.getMatch(), logicalColumnType, columnType, isArray, rawConfiguration, configuration);
    }

    private static EnclosureMatch extractConfiguration(String columnNameValue) {
        return EnclosureMatch.parseEnclosure('{', '}', columnNameValue, true);
    }

    private static EnclosureMatch extractGroupName(String columnNameValue) {
        return EnclosureMatch.parseEnclosure('(', ')', columnNameValue, false);
    }

    private static Map<String, String> parseConfiguration(String rawConfiguration) {
        if (rawConfiguration == null) {
            return Collections.emptyMap();
        }
        return Value.parseStringMap((CharSequence)rawConfiguration);
    }

    String idLabel() {
        return this.configuration.get("label");
    }

    IdType columnIdType() {
        String idTypeValue = this.configuration.get("id-type");
        if (idTypeValue == null || idTypeValue.isBlank()) {
            return null;
        }
        return switch (idTypeValue.toUpperCase(Locale.ROOT)) {
            case "INT" -> IdType.INTEGER;
            case "STRING" -> IdType.STRING;
            case "ACTUAL" -> IdType.ACTUAL;
            default -> IdType.ACTUAL;
        };
    }

    private static String extractLogicalColumnType(String columnNameValue) {
        if (!columnNameValue.contains(":")) {
            return null;
        }
        return columnNameValue.split(":", 2)[1].trim();
    }

    private static String extractColumnType(ParquetLogicalColumnType logicalColumnType, String columnNameValue) {
        if (!columnNameValue.contains(":") || logicalColumnType != ParquetLogicalColumnType.PROPERTY) {
            return null;
        }
        return columnNameValue.split(":", 2)[1];
    }

    private static String extractPropertyName(String columnNameValue) {
        String[] columnNameParts = columnNameValue.split(":", 2);
        return columnNameParts[0].isBlank() ? null : columnNameParts[0];
    }

    private static boolean hasArrayDefinition(String columnName) {
        if (!columnName.contains(":")) {
            return columnName.endsWith("[]");
        }
        return columnName.split(":")[1].contains("[]");
    }

    boolean isRaw() {
        return this.columnType == ParquetColumnType.RAW;
    }

    boolean hasConfiguration() {
        return this.rawConfiguration() != null;
    }

    ParquetColumn withoutArray() {
        return new ParquetColumn(this.columnName(), this.propertyName(), this.groupName(), this.logicalColumnType(), this.columnType(), false, this.rawConfiguration(), this.configuration());
    }

    boolean hasPropertyName() {
        return this.propertyName != null && !this.propertyName.isBlank();
    }

    boolean isIdColumn() {
        return this.logicalColumnType == ParquetLogicalColumnType.ID;
    }

    boolean isLabelColumn() {
        return this.logicalColumnType == ParquetLogicalColumnType.LABEL;
    }

    boolean isStartId() {
        return this.logicalColumnType == ParquetLogicalColumnType.START_ID;
    }

    boolean isEndId() {
        return this.logicalColumnType == ParquetLogicalColumnType.END_ID;
    }

    boolean isType() {
        return this.logicalColumnType == ParquetLogicalColumnType.TYPE;
    }

    boolean isIgnoredColumn() {
        return this.logicalColumnType == ParquetLogicalColumnType.IGNORED;
    }

    Supplier<ZoneId> getTimezone(Supplier<ZoneId> defaultTimezoneSupplier) {
        if (!this.hasConfiguration()) {
            return defaultTimezoneSupplier;
        }
        return () -> {
            String zoneIdValue = this.configuration.get("timezone");
            if (zoneIdValue == null) {
                return (ZoneId)defaultTimezoneSupplier.get();
            }
            return ZoneId.of(zoneIdValue);
        };
    }

    static String getReservedColumns(EntityType entityType) {
        return "Column types: " + Arrays.toString((Object[])ParquetColumnType.values()) + ", logical types: " + ParquetLogicalColumnType.getReservedColumns(entityType);
    }

    private record EnclosureMatch(char startSymbol, char endSymbol, int startIndex, int endIndex, String parsedMatch) {
        static EnclosureMatch parseEnclosure(char start, char end, String content, boolean includeSymbols) {
            int startIndex = content.indexOf("" + start);
            if (startIndex == -1) {
                return EnclosureMatch.unmatched(start, end);
            }
            int endIndex = content.lastIndexOf("" + end);
            if (endIndex == -1) {
                return EnclosureMatch.unmatched(start, end);
            }
            String match = content.substring(startIndex + 1, endIndex).trim();
            if (!includeSymbols) {
                return new EnclosureMatch(start, end, startIndex, endIndex, match);
            }
            return new EnclosureMatch(start, end, startIndex, endIndex, "%c%s%c".formatted(Character.valueOf(start), match, Character.valueOf(end)));
        }

        private static EnclosureMatch unmatched(char start, char end) {
            return new EnclosureMatch(start, end, -1, -1, null);
        }

        String removeFrom(String content) {
            if (!this.matches()) {
                return content;
            }
            String startString = content.substring(0, this.startIndex);
            if (this.endIndex == content.length() - 1) {
                return startString;
            }
            return "%s%s".formatted(startString, content.substring(this.endIndex + 1));
        }

        EnclosureMatch adjustAfterRemovalOf(EnclosureMatch other) {
            if (!this.matches() || !other.matches()) {
                return this;
            }
            int otherMatchLength = other.endIndex - other.startIndex + 1;
            return new EnclosureMatch(this.startSymbol, this.endSymbol, this.startIndex - otherMatchLength, this.endIndex - otherMatchLength, this.parsedMatch);
        }

        String getMatch() {
            return this.parsedMatch;
        }

        private boolean matches() {
            return this.parsedMatch != null;
        }
    }
}

