/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import org.neo4j.internal.batchimport.cache.ByteArray;
import org.neo4j.internal.batchimport.cache.ChunkedNumberArrayFactory;
import org.neo4j.internal.batchimport.cache.HeapByteArray;
import org.neo4j.internal.batchimport.cache.HeapIntArray;
import org.neo4j.internal.batchimport.cache.HeapLongArray;
import org.neo4j.internal.batchimport.cache.IntArray;
import org.neo4j.internal.batchimport.cache.LongArray;
import org.neo4j.internal.batchimport.cache.NumberArray;
import org.neo4j.internal.batchimport.cache.NumberArrayFactory;
import org.neo4j.internal.batchimport.cache.OffHeapByteArray;
import org.neo4j.internal.batchimport.cache.OffHeapIntArray;
import org.neo4j.internal.batchimport.cache.OffHeapLongArray;
import org.neo4j.internal.batchimport.cache.PageCachedNumberArrayFactory;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.internal.unsafe.NativeMemoryAllocationRefusedError;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.logging.InternalLog;
import org.neo4j.memory.MemoryTracker;

public class NumberArrayFactories {
    public static final NumberArrayFactory.Monitor NO_MONITOR = (memory, successfulFactory, attemptedAllocationFailures) -> {};
    public static final NumberArrayFactory HEAP = new NumberArrayFactory.Adapter(){

        @Override
        public IntArray newIntArray(long length, int defaultValue, long base, MemoryTracker memoryTracker) {
            return new HeapIntArray(Math.toIntExact(length), defaultValue, base, memoryTracker);
        }

        @Override
        public LongArray newLongArray(long length, long defaultValue, long base, MemoryTracker memoryTracker) {
            return new HeapLongArray(Math.toIntExact(length), defaultValue, base, memoryTracker);
        }

        @Override
        public HeapByteArray newByteArray(long length, byte[] defaultValue, long base, MemoryTracker memoryTracker) {
            return new HeapByteArray(Math.toIntExact(length), defaultValue, base, memoryTracker);
        }

        public String toString() {
            return "HEAP";
        }
    };
    public static final NumberArrayFactory OFF_HEAP = new NumberArrayFactory.Adapter(){

        @Override
        public IntArray newIntArray(long length, int defaultValue, long base, MemoryTracker memoryTracker) {
            return new OffHeapIntArray(length, defaultValue, base, memoryTracker);
        }

        @Override
        public LongArray newLongArray(long length, long defaultValue, long base, MemoryTracker memoryTracker) {
            return new OffHeapLongArray(length, defaultValue, base, memoryTracker);
        }

        @Override
        public ByteArray newByteArray(long length, byte[] defaultValue, long base, MemoryTracker memoryTracker) {
            return new OffHeapByteArray(length, defaultValue, base, memoryTracker);
        }

        public String toString() {
            return "OFF_HEAP";
        }
    };
    public static final NumberArrayFactory CHUNKED_FIXED_SIZE = new ChunkedNumberArrayFactory(NO_MONITOR, OFF_HEAP, HEAP);
    public static final NumberArrayFactory AUTO_WITHOUT_PAGECACHE = new Auto(NO_MONITOR, OFF_HEAP, HEAP, CHUNKED_FIXED_SIZE);

    private NumberArrayFactories() {
    }

    public static NumberArrayFactory auto(PageCache pageCache, CursorContextFactory contextFactory, Path dir, boolean allowHeapAllocation, NumberArrayFactory.Monitor monitor, InternalLog log, String databaseName) {
        PageCachedNumberArrayFactory pagedArrayFactory = new PageCachedNumberArrayFactory(pageCache, contextFactory, dir, log, databaseName);
        ChunkedNumberArrayFactory chunkedArrayFactory = new ChunkedNumberArrayFactory(monitor, NumberArrayFactories.allocationAlternatives(allowHeapAllocation, pagedArrayFactory));
        return new Auto(monitor, NumberArrayFactories.allocationAlternatives(allowHeapAllocation, chunkedArrayFactory));
    }

    private static NumberArrayFactory[] allocationAlternatives(boolean allowHeapAllocation, NumberArrayFactory ... additional) {
        ArrayList<NumberArrayFactory> result = new ArrayList<NumberArrayFactory>(Collections.singletonList(OFF_HEAP));
        if (allowHeapAllocation) {
            result.add(HEAP);
        }
        result.addAll(Arrays.asList(additional));
        return result.toArray(new NumberArrayFactory[0]);
    }

    static class Auto
    extends NumberArrayFactory.Adapter {
        private final NumberArrayFactory.Monitor monitor;
        private final NumberArrayFactory[] candidates;

        Auto(NumberArrayFactory.Monitor monitor, NumberArrayFactory ... candidates) {
            Objects.requireNonNull(monitor);
            this.monitor = monitor;
            this.candidates = candidates;
        }

        @Override
        public LongArray newLongArray(long length, long defaultValue, long base, MemoryTracker memoryTracker) {
            return this.tryAllocate(length, 8, f -> f.newLongArray(length, defaultValue, base, memoryTracker));
        }

        @Override
        public IntArray newIntArray(long length, int defaultValue, long base, MemoryTracker memoryTracker) {
            return this.tryAllocate(length, 4, f -> f.newIntArray(length, defaultValue, base, memoryTracker));
        }

        @Override
        public ByteArray newByteArray(long length, byte[] defaultValue, long base, MemoryTracker memoryTracker) {
            return this.tryAllocate(length, defaultValue.length, f -> f.newByteArray(length, defaultValue, base, memoryTracker));
        }

        private <T extends NumberArray<? extends T>> T tryAllocate(long length, int itemSize, Function<NumberArrayFactory, T> allocator) {
            ArrayList<NumberArrayFactory.AllocationFailure> failures = new ArrayList<NumberArrayFactory.AllocationFailure>();
            Error error = null;
            for (NumberArrayFactory candidate : this.candidates) {
                try {
                    try {
                        NumberArray array = (NumberArray)allocator.apply(candidate);
                        this.monitor.allocationSuccessful(length * (long)itemSize, candidate, failures);
                        return (T)array;
                    }
                    catch (ArithmeticException e) {
                        throw new OutOfMemoryError(e.getMessage());
                    }
                }
                catch (OutOfMemoryError | NativeMemoryAllocationRefusedError e) {
                    error = (Error)Exceptions.chain((Throwable)e, error);
                    failures.add(new NumberArrayFactory.AllocationFailure(e, candidate));
                }
            }
            throw (Error)Exceptions.chain((Throwable)new OutOfMemoryError(String.format("Not enough memory available for allocating %s, tried %s", ByteUnit.bytesToString((long)(length * (long)itemSize)), Arrays.toString(this.candidates))), (Throwable)error);
        }
    }
}

