/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.neo4j.internal.batchimport.input.Group;
import org.neo4j.internal.batchimport.input.HeaderException;
import org.neo4j.internal.batchimport.input.ReadableGroups;
import org.neo4j.util.Preconditions;

public class Groups
implements ReadableGroups {
    private final Map<String, Group> byName = new HashMap<String, Group>();
    private final List<Group> byId = new ArrayList<Group>();
    private int nextId = 0;

    public Group getOrCreate(String name) {
        return this.getOrCreate(name, null);
    }

    public synchronized Group getOrCreate(String name, String specificIdType) {
        Group group = this.byName.get(name);
        if (group == null) {
            group = new Group(this.nextId++, name, specificIdType);
            this.byName.put(name, group);
            this.byId.add(group);
        } else {
            Preconditions.checkState((boolean)Objects.equals(specificIdType, group.specificIdType()), (String)"Group '%s' has different specific type %s in different places. Was created with '%s' and later used with '%s'", (Object[])new Object[]{group.name(), group.specificIdType(), specificIdType});
        }
        return group;
    }

    public synchronized Group get(String name) {
        Group group = this.byName.get(name);
        if (group == null) {
            throw new HeaderException("Group '" + name + "' not found. Available groups are: " + this.groupNames());
        }
        return group;
    }

    public Group get(int id) {
        if (id < 0 || id >= this.byId.size()) {
            throw new HeaderException("Group with id " + id + " not found");
        }
        return this.byId.get(id);
    }

    private String groupNames() {
        return Arrays.toString(this.byName.keySet().toArray(new String[0]));
    }

    public int size() {
        return this.nextId;
    }
}

