/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.staging;

import java.util.Arrays;
import java.util.stream.LongStream;
import org.neo4j.common.DependencyResolver;
import org.neo4j.internal.batchimport.staging.ExecutionMonitor;
import org.neo4j.internal.batchimport.staging.StageExecution;

public class MultiExecutionMonitor
implements ExecutionMonitor {
    private final ExecutionMonitor[] monitors;
    private final long[] nextIntervals;
    private final long checkInterval;

    public MultiExecutionMonitor(ExecutionMonitor ... monitors) {
        this.monitors = monitors;
        this.nextIntervals = Arrays.stream(monitors).mapToLong(ExecutionMonitor::checkIntervalMillis).toArray();
        this.checkInterval = LongStream.of(this.nextIntervals).min().orElse(0L);
    }

    @Override
    public void initialize(DependencyResolver dependencyResolver) {
        for (ExecutionMonitor monitor : this.monitors) {
            monitor.initialize(dependencyResolver);
        }
    }

    @Override
    public void start(StageExecution execution) {
        for (ExecutionMonitor monitor : this.monitors) {
            monitor.start(execution);
        }
    }

    @Override
    public void end(StageExecution execution, long totalTimeMillis) {
        for (ExecutionMonitor monitor : this.monitors) {
            monitor.end(execution, totalTimeMillis);
        }
    }

    @Override
    public void done(boolean successful, long totalTimeMillis, String additionalInformation) {
        for (ExecutionMonitor monitor : this.monitors) {
            monitor.done(successful, totalTimeMillis, additionalInformation);
        }
    }

    @Override
    public long checkIntervalMillis() {
        return this.checkInterval;
    }

    @Override
    public void check(StageExecution execution) {
        for (int i = 0; i < this.nextIntervals.length; ++i) {
            int n = i;
            this.nextIntervals[n] = this.nextIntervals[n] - this.checkInterval;
            if (this.nextIntervals[i] > 0L) continue;
            this.monitors[i].check(execution);
            int n2 = i;
            this.nextIntervals[n2] = this.nextIntervals[n2] + this.monitors[i].checkIntervalMillis();
        }
    }
}

