/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache;

import org.neo4j.internal.batchimport.cache.DynamicNumberArray;
import org.neo4j.internal.batchimport.cache.IntArray;
import org.neo4j.internal.batchimport.cache.NumberArray;
import org.neo4j.internal.batchimport.cache.NumberArrayFactory;

public class DynamicIntArray
extends DynamicNumberArray<IntArray>
implements IntArray {
    private final int defaultValue;

    public DynamicIntArray(NumberArrayFactory factory, long chunkSize, int defaultValue) {
        super(factory, chunkSize, (NumberArray[])new IntArray[0]);
        this.defaultValue = defaultValue;
    }

    @Override
    public int get(long index) {
        IntArray chunk = (IntArray)this.chunkOrNullAt(index);
        return chunk != null ? chunk.get(index) : this.defaultValue;
    }

    @Override
    public void set(long index, int value) {
        ((IntArray)this.at(index)).set(index, value);
    }

    @Override
    protected IntArray addChunk(long chunkSize, long base) {
        return this.factory.newIntArray(chunkSize, this.defaultValue, base);
    }
}

