/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input.parquet;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.List;
import org.neo4j.batchimport.api.InputIterator;
import org.neo4j.batchimport.api.input.IdType;
import org.neo4j.batchimport.api.input.InputChunk;
import org.neo4j.internal.batchimport.input.Groups;
import org.neo4j.internal.batchimport.input.parquet.ParquetData;
import org.neo4j.internal.batchimport.input.parquet.ParquetDataInputChunk;
import org.neo4j.internal.batchimport.input.parquet.ParquetInputChunk;
import org.neo4j.internal.batchimport.input.parquet.ParquetInputIterator;

class ParquetGroupInputIterator
implements InputIterator {
    private final Iterator<ParquetData> files;
    private final Groups groups;
    private final IdType idType;
    private final String arrayDelimiter;
    private ParquetInputIterator current;

    ParquetGroupInputIterator(List<ParquetData> files, Groups groups, IdType idType, String arrayDelimiter) {
        this.files = files.iterator();
        this.groups = groups;
        this.idType = idType;
        this.arrayDelimiter = arrayDelimiter;
    }

    public InputChunk newChunk() {
        return new ParquetDataInputChunk();
    }

    public synchronized boolean next(InputChunk chunk) throws IOException {
        while (true) {
            if (this.current == null) {
                if (!this.files.hasNext()) {
                    return false;
                }
                ParquetData nextFile = this.files.next();
                this.current = new ParquetInputIterator(nextFile, this.groups, this.idType, nextFile.defaultTimezoneSupplier(), this.arrayDelimiter);
            }
            if (this.current.next((ParquetInputChunk)chunk)) {
                return true;
            }
            this.current.close();
            this.current = null;
        }
    }

    public void close() {
        if (this.current != null) {
            try {
                this.current.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

