/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.internal.batchimport.cache.BufferFactories;
import org.neo4j.internal.batchimport.cache.BufferFactory;
import org.neo4j.internal.batchimport.cache.ByteArray;
import org.neo4j.internal.batchimport.cache.ByteArrayImpl;
import org.neo4j.internal.batchimport.cache.IntArray;
import org.neo4j.internal.batchimport.cache.IntArrayImpl;
import org.neo4j.internal.batchimport.cache.LongArray;
import org.neo4j.internal.batchimport.cache.LongArrayImpl;
import org.neo4j.internal.batchimport.cache.NumberArrayFactory;
import org.neo4j.internal.batchimport.cache.SwappingBufferFactory;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.internal.unsafe.NativeMemoryAllocationRefusedError;
import org.neo4j.internal.unsafe.UnsafeUtil;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.NullLog;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.Preconditions;

public final class NumberArrayFactories {
    public static final NumberArrayFactory HEAP = new NumberArrayFactoryImpl(BufferFactories.HEAP);
    public static final NumberArrayFactory OFF_HEAP = new NumberArrayFactoryImpl(BufferFactories.OFF_HEAP);
    public static final NumberArrayFactory AUTO_WITHOUT_SWAP = new NumberArrayFactoryImpl(new Auto((InternalLog)NullLog.getInstance(), BufferFactories.OFF_HEAP, BufferFactories.HEAP));

    private NumberArrayFactories() {
    }

    public static NumberArrayFactory auto(FileSystemAbstraction fs, Path dir, boolean allowHeapAllocation, InternalLog log) {
        try {
            SwappingBufferFactory swappingBufferFactory = new SwappingBufferFactory(fs, dir);
            return new NumberArrayFactoryImpl(new Auto(log, NumberArrayFactories.allocationAlternatives(allowHeapAllocation, swappingBufferFactory)));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static BufferFactory[] allocationAlternatives(boolean allowHeapAllocation, BufferFactory ... additional) {
        ArrayList<BufferFactory> result = new ArrayList<BufferFactory>(Collections.singletonList(BufferFactories.OFF_HEAP));
        if (allowHeapAllocation) {
            result.add(BufferFactories.HEAP);
        }
        result.addAll(Arrays.asList(additional));
        return result.toArray(new BufferFactory[0]);
    }

    public static NumberArrayFactory fromBufferFactory(BufferFactory bufferFactory) {
        return new NumberArrayFactoryImpl(bufferFactory);
    }

    static class NumberArrayFactoryImpl
    implements NumberArrayFactory {
        private final BufferFactory bufferFactory;

        NumberArrayFactoryImpl(BufferFactory bufferFactory) {
            this.bufferFactory = bufferFactory;
        }

        @Override
        public IntArray newIntArray(long length, int defaultValue, MemoryTracker memoryTracker) {
            if (length == 0L) {
                return IntArray.EMPTY_ARRAY;
            }
            return new IntArrayImpl(length, 0, NumberArrayFactoryImpl.toUniformByte(defaultValue), this.bufferFactory, memoryTracker);
        }

        @Override
        public IntArray newDynamicIntArray(int chunkSize, int defaultValue, MemoryTracker memoryTracker) {
            return new IntArrayImpl(0L, chunkSize, NumberArrayFactoryImpl.toUniformByte(defaultValue), this.bufferFactory, memoryTracker);
        }

        @Override
        public LongArray newLongArray(long length, long defaultValue, MemoryTracker memoryTracker) {
            if (length == 0L) {
                return LongArray.EMPTY_ARRAY;
            }
            return new LongArrayImpl(length, 0, NumberArrayFactoryImpl.toUniformByte(defaultValue), this.bufferFactory, memoryTracker);
        }

        @Override
        public LongArray newDynamicLongArray(int chunkSize, long defaultValue, MemoryTracker memoryTracker) {
            return new LongArrayImpl(0L, chunkSize, NumberArrayFactoryImpl.toUniformByte(defaultValue), this.bufferFactory, memoryTracker);
        }

        @Override
        public ByteArray newByteArray(long length, byte[] defaultValue, MemoryTracker memoryTracker) {
            if (length == 0L) {
                return ByteArray.EMPTY_ARRAY;
            }
            return new ByteArrayImpl(length, defaultValue.length, 0, NumberArrayFactoryImpl.toUniformByte(defaultValue), this.bufferFactory, memoryTracker);
        }

        @Override
        public ByteArray newDynamicByteArray(int chunkSize, byte[] defaultValue, MemoryTracker memoryTracker) {
            return new ByteArrayImpl(0L, defaultValue.length, chunkSize, NumberArrayFactoryImpl.toUniformByte(defaultValue), this.bufferFactory, memoryTracker);
        }

        @Override
        public void close() {
            IOUtils.closeAllUnchecked((AutoCloseable[])new AutoCloseable[]{this.bufferFactory});
        }

        private static byte toUniformByte(int v) {
            return NumberArrayFactoryImpl.toUniformByte(new byte[]{(byte)(v >> 24), (byte)(v >> 16), (byte)(v >> 8), (byte)v});
        }

        private static byte toUniformByte(long v) {
            return NumberArrayFactoryImpl.toUniformByte(new byte[]{(byte)(v >> 56), (byte)(v >> 48), (byte)(v >> 40), (byte)(v >> 32), (byte)(v >> 24), (byte)(v >> 16), (byte)(v >> 8), (byte)v});
        }

        private static byte toUniformByte(byte[] bytes) {
            byte reference = bytes[0];
            for (int i = 1; i < bytes.length; ++i) {
                Preconditions.checkArgument((reference == bytes[i] ? 1 : 0) != 0, (String)"Default value must be uniform");
            }
            return reference;
        }
    }

    static class Auto
    implements BufferFactory {
        private final InternalLog log;
        private final BufferFactory[] candidates;
        private volatile BufferFactory currentFactory;
        private Error error;

        Auto(InternalLog log, BufferFactory ... candidates) {
            this.log = log;
            this.candidates = candidates;
            this.currentFactory = candidates[0];
        }

        @Override
        public BufferFactory.AllocatedBuffer allocate(int size, MemoryTracker memoryTracker) {
            BufferFactory bufferFactory = this.currentFactory;
            while (true) {
                try {
                    return bufferFactory.allocate(size, memoryTracker);
                }
                catch (OutOfMemoryError | NativeMemoryAllocationRefusedError e) {
                    bufferFactory = this.switchFactory(bufferFactory, size, (Error)e);
                    continue;
                }
                break;
            }
        }

        private synchronized BufferFactory switchFactory(BufferFactory failedCandidate, int size, Error e) {
            if (this.currentFactory == failedCandidate) {
                this.error = (Error)Exceptions.chain((Throwable)e, (Throwable)this.error);
                int nextIndex = ArrayUtils.indexOf((Object[])this.candidates, (Object)failedCandidate) + 1;
                if (nextIndex > this.candidates.length) {
                    throw (Error)Exceptions.chain((Throwable)new OutOfMemoryError(String.format("Not enough memory available for allocating %s, tried %s", ByteUnit.bytesToString((long)size), Arrays.toString(this.candidates))), (Throwable)this.error);
                }
                this.currentFactory = this.candidates[nextIndex];
                this.currentFactory.warnForUsage(this.log);
            }
            return this.currentFactory;
        }

        @Override
        public void clear(ByteBuffer buffer, byte defaultValue) {
            if (buffer.hasArray()) {
                Arrays.fill(buffer.array(), defaultValue);
            } else {
                UnsafeUtil.setMemory((long)UnsafeUtil.getDirectByteBufferAddress((Buffer)buffer), (long)buffer.capacity(), (byte)defaultValue);
            }
        }

        @Override
        public void close() {
            IOUtils.closeAllUnchecked((AutoCloseable[])this.candidates);
        }
    }
}

