/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.importer;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.tuple.Tuples;
import org.neo4j.cli.AbstractAdminCommand;
import org.neo4j.cli.Converters;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.importer.CharacterConverter;
import org.neo4j.importer.CsvImporter;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.IndexConfig;
import org.neo4j.internal.batchimport.input.IdType;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.layout.recordstorage.RecordDatabaseLayout;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import org.neo4j.kernel.impl.util.Converters;
import org.neo4j.kernel.impl.util.Validators;
import org.neo4j.util.VisibleForTesting;
import picocli.CommandLine;

@CommandLine.Command(name="import", description={"Import a collection of CSV files."}, subcommands={Full.class, Incremental.class, CommandLine.HelpCommand.class})
public class ImportCommand {
    private static final String MULTI_FILE_DELIMITER = ",";
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"Show this help message and exit."})
    private boolean helpRequested;

    @VisibleForTesting
    static RelationshipFilesGroup parseRelationshipFilesGroup(String str) {
        Pair<String, Path[]> p = ImportCommand.parseInputFilesGroup(str, String::trim);
        return new RelationshipFilesGroup((String)p.getOne(), (Path[])p.getTwo());
    }

    @VisibleForTesting
    static NodeFilesGroup parseNodeFilesGroup(String str) {
        Pair<Set, Path[]> p = ImportCommand.parseInputFilesGroup(str, s -> Arrays.stream(s.split(":")).map(String::trim).filter(x -> !x.isEmpty()).collect(Collectors.toSet()));
        return new NodeFilesGroup((Set)p.getOne(), (Path[])p.getTwo());
    }

    private static <T> Pair<T, Path[]> parseInputFilesGroup(String str, Function<String, ? extends T> keyParser) {
        int i = str.indexOf(61);
        if (i < 0) {
            return Tuples.pair(keyParser.apply(""), (Object)ImportCommand.parseFilesList(str));
        }
        if (i == 0 || i == str.length() - 1) {
            throw new IllegalArgumentException("illegal `=` position: " + str);
        }
        String keyStr = str.substring(0, i);
        String filesStr = str.substring(i + 1);
        T key = keyParser.apply(keyStr);
        Path[] files = ImportCommand.parseFilesList(filesStr);
        return Tuples.pair(key, (Object)files);
    }

    private static Path[] parseFilesList(String str) {
        Function converter = Converters.regexFiles((boolean)true);
        return (Path[])Converters.toFiles((String)MULTI_FILE_DELIMITER, s -> {
            Validators.REGEX_FILE_EXISTS.validate(s);
            return (Path[])converter.apply(s);
        }).apply(str);
    }

    static class RelationshipFilesGroup
    extends InputFilesGroup<String> {
        RelationshipFilesGroup(String key, Path[] files) {
            super(key, files);
        }
    }

    static class NodeFilesGroup
    extends InputFilesGroup<Set<String>> {
        NodeFilesGroup(Set<String> key, Path[] files) {
            super(key, files);
        }
    }

    static abstract class InputFilesGroup<T> {
        final T key;
        final Path[] files;

        InputFilesGroup(T key, Path[] files) {
            this.key = key;
            this.files = files;
        }
    }

    @CommandLine.Command(name="incremental", description={"Incremental import into an existing database."})
    public static class Incremental
    extends Base {
        @CommandLine.Option(names={"--stage"}, paramLabel="all|prepare|build|merge", description={"Stage of incremental import. For incremental import into an existing database use 'all' (which requires the database to be stopped. For semi-online incremental import run 'prepare' (on stopped database) followed by 'build' (on a potentially running database) and finally 'merge' (on stopped database)"}, converter={StageConverter.class})
        CsvImporter.IncrementalStage stage = CsvImporter.IncrementalStage.all;
        @CommandLine.Option(names={"--force"}, required=true, description={"Confirm incremental import by setting this flag"})
        boolean forced;

        public Incremental(ExecutionContext ctx) {
            super(ctx);
        }

        public void execute() throws Exception {
            if (!this.forced) {
                System.err.println("ERROR: Incremental import needs to be used with care. Please confirm by specifying --force");
                throw new IllegalArgumentException("Missing force");
            }
            this.doExecute(true, this.stage, null, false);
        }

        static class StageConverter
        implements CommandLine.ITypeConverter<CsvImporter.IncrementalStage> {
            StageConverter() {
            }

            public CsvImporter.IncrementalStage convert(String in) {
                in = switch (in) {
                    case "1" -> "prepare";
                    case "2" -> "build";
                    case "3" -> "merge";
                    default -> in.toLowerCase();
                };
                try {
                    return CsvImporter.IncrementalStage.valueOf(in);
                }
                catch (Exception e) {
                    throw new CommandLine.TypeConversionException(String.format("Invalid stage: %s (%s)", in, e));
                }
            }
        }
    }

    @CommandLine.Command(name="full", description={"Initial import into a non-existent empty database."})
    public static class Full
    extends Base {
        @CommandLine.Option(names={"--format"}, showDefaultValue=CommandLine.Help.Visibility.NEVER, required=false, description={"Name of database format. Imported database will be created of the specified format or use format from configuration if not specifed."})
        private String format;
        @CommandLine.Option(names={"--overwrite-destination"}, arity="0..1", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, paramLabel="true|false", fallbackValue="true", description={"Delete any existing database files prior to the import."})
        private boolean overwriteDestination;

        public Full(ExecutionContext ctx) {
            super(ctx);
        }

        public void execute() throws Exception {
            this.doExecute(false, null, this.format, this.overwriteDestination);
        }
    }

    private static abstract class Base
    extends AbstractAdminCommand {
        private static final Function<String, Character> CHARACTER_CONVERTER = new CharacterConverter();
        private static final org.neo4j.csv.reader.Configuration DEFAULT_CSV_CONFIG = org.neo4j.csv.reader.Configuration.COMMAS;
        private static final org.neo4j.internal.batchimport.Configuration DEFAULT_IMPORTER_CONFIG = org.neo4j.internal.batchimport.Configuration.DEFAULT;
        @CommandLine.Parameters(index="0", converter={Converters.DatabaseNameConverter.class}, defaultValue="neo4j", description={"Name of the database to import.%n  If the database used to import into doesn't exist prior to importing,%n  then it must be created subsequently using CREATE DATABASE."})
        private NormalizedDatabaseName database;
        @CommandLine.Option(names={"--report-file"}, paramLabel="<path>", defaultValue="import.report", description={"File in which to store the report of the csv-import."})
        private Path reportFile = Path.of("import.report", new String[0]);
        @CommandLine.Option(names={"--id-type"}, paramLabel="string|integer|actual", defaultValue="string", description={"Each node must provide a unique id. This is used to find the correct nodes when creating relationships. Possible values are:%n  string: arbitrary strings for identifying nodes,%n  integer: arbitrary integer values for identifying nodes,%n  actual: (advanced) actual node ids.%nFor more information on id handling, please see the Neo4j Manual: https://neo4j.com/docs/operations-manual/current/tools/import/"}, converter={IdTypeConverter.class})
        IdType idType = IdType.STRING;
        @CommandLine.Option(names={"--input-encoding"}, paramLabel="<character-set>", description={"Character set that input data is encoded in."})
        private Charset inputEncoding = StandardCharsets.UTF_8;
        @CommandLine.Option(names={"--ignore-extra-columns"}, arity="0..1", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, paramLabel="true|false", fallbackValue="true", description={"If un-specified columns should be ignored during the import."})
        private boolean ignoreExtraColumns;
        @CommandLine.Option(names={"--multiline-fields"}, arity="0..1", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, paramLabel="true|false", fallbackValue="true", description={"Whether or not fields from input source can span multiple lines, i.e. contain newline characters."})
        private boolean multilineFields = DEFAULT_CSV_CONFIG.multilineFields();
        @CommandLine.Option(names={"--ignore-empty-strings"}, arity="0..1", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, paramLabel="true|false", fallbackValue="true", description={"Whether or not empty string fields, i.e. \"\" from input source are ignored, i.e. treated as null."})
        private boolean ignoreEmptyStrings = DEFAULT_CSV_CONFIG.emptyQuotedStringsAsNull();
        @CommandLine.Option(names={"--trim-strings"}, arity="0..1", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, paramLabel="true|false", fallbackValue="true", description={"Whether or not strings should be trimmed for whitespaces."})
        private boolean trimStrings = DEFAULT_CSV_CONFIG.trimStrings();
        @CommandLine.Option(names={"--legacy-style-quoting"}, arity="0..1", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, paramLabel="true|false", fallbackValue="true", description={"Whether or not backslash-escaped quote e.g. \\\" is interpreted as inner quote."})
        private boolean legacyStyleQuoting = DEFAULT_CSV_CONFIG.legacyStyleQuoting();
        @CommandLine.Option(names={"--delimiter"}, paramLabel="<char>", converter={EscapedCharacterConverter.class}, description={"Delimiter character between values in CSV data. Also accepts 'TAB' and e.g. 'U+20AC' for specifying character using unicode."})
        private char delimiter = DEFAULT_CSV_CONFIG.delimiter();
        @CommandLine.Option(names={"--array-delimiter"}, paramLabel="<char>", converter={EscapedCharacterConverter.class}, description={"Delimiter character between array elements within a value in CSV data. Also accepts 'TAB' and e.g. 'U+20AC' for specifying character using unicode."})
        private char arrayDelimiter = DEFAULT_CSV_CONFIG.arrayDelimiter();
        @CommandLine.Option(names={"--quote"}, paramLabel="<char>", converter={EscapedCharacterConverter.class}, description={"Character to treat as quotation character for values in CSV data. Quotes can be escaped as per RFC 4180 by doubling them, for example \"\" would be interpreted as a literal \". You cannot escape using \\."})
        private char quote = DEFAULT_CSV_CONFIG.quotationCharacter();
        @CommandLine.Option(names={"--read-buffer-size"}, paramLabel="<size>", converter={Converters.ByteUnitConverter.class}, description={"Size of each buffer for reading input data. The size has to at least be large enough to hold the biggest single value in the input data. The value can be a plain number or a byte units string, e.g. 128k, 1m."})
        private long bufferSize = DEFAULT_CSV_CONFIG.bufferSize();
        @CommandLine.Option(names={"--max-off-heap-memory"}, paramLabel="<size>", defaultValue="90%", converter={Converters.MaxOffHeapMemoryConverter.class}, description={"Maximum memory that neo4j-admin can use for various data structures and caching to improve performance. Values can be plain numbers, like 10000000 or e.g. 20G for 20 gigabyte, or even e.g. 70%%."})
        private long maxOffHeapMemory;
        @CommandLine.Option(names={"--high-parallel-io"}, showDefaultValue=CommandLine.Help.Visibility.ALWAYS, paramLabel="on|off|auto", defaultValue="auto", converter={OnOffAutoConverter.class}, description={"Indicate if target storage subsystem can support parallel IO with high throughput or auto detect."})
        private OnOffAuto highIo;
        @CommandLine.Option(names={"--threads"}, paramLabel="<num>", description={"(advanced) Max number of worker threads used by the importer. Defaults to the number of available processors reported by the JVM. There is a certain amount of minimum threads needed so for that reason there is no lower bound for this value. For optimal performance this value shouldn't be greater than the number of available processors."})
        private int threads = DEFAULT_IMPORTER_CONFIG.maxNumberOfWorkerThreads();
        @CommandLine.Option(names={"--bad-tolerance"}, paramLabel="<num>", description={"Number of bad entries before the import is considered failed. This tolerance threshold is about relationships referring to missing nodes. Format errors in input data are still treated as errors"})
        private long badTolerance = 1000L;
        @CommandLine.Option(names={"--skip-bad-entries-logging"}, arity="0..1", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, paramLabel="true|false", fallbackValue="true", description={"Whether or not to skip logging bad entries detected during import."})
        private boolean skipBadEntriesLogging;
        @CommandLine.Option(names={"--skip-bad-relationships"}, arity="0..1", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, paramLabel="true|false", fallbackValue="true", description={"Whether or not to skip importing relationships that refers to missing node ids, i.e. either start or end node id/group referring to node that wasn't specified by the node input data. Skipped relationships will be logged, containing at most number of entities specified by bad-tolerance, unless otherwise specified by skip-bad-entries-logging option."})
        private boolean skipBadRelationships;
        @CommandLine.Option(names={"--strict"}, arity="0..1", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, paramLabel="<true/false>", description={"Whether or not the lookup of nodes referred to from relationships needs to be checked strict. If disabled, most but not all relationships referring to non-existent nodes will be detected. If enabled all those relationships will be found but to the cost of lower performance"})
        private boolean strict = true;
        @CommandLine.Option(names={"--skip-duplicate-nodes"}, arity="0..1", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, paramLabel="true|false", fallbackValue="true", description={"Whether or not to skip importing nodes that have the same id/group. In the event of multiple nodes within the same group having the same id, the first encountered will be imported whereas consecutive such nodes will be skipped. Skipped nodes will be logged, containing at most number of entities specified by bad-tolerance, unless otherwise specified by skip-bad-entries-logging option."})
        private boolean skipDuplicateNodes;
        @CommandLine.Option(names={"--normalize-types"}, arity="0..1", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, paramLabel="true|false", fallbackValue="true", description={"Whether or not to normalize property types to Cypher types, e.g. 'int' becomes 'long' and 'float' becomes 'double'"})
        private boolean normalizeTypes = true;
        @CommandLine.Option(names={"--nodes"}, required=true, arity="1..*", converter={NodeFilesConverter.class}, paramLabel="[<label>[:<label>]...=]<files>", description={"Node CSV header and data. Multiple files will be logically seen as one big file from the perspective of the importer. The first line must contain the header. Multiple data sources like these can be specified in one import, where each data source has its own header."})
        private List<NodeFilesGroup> nodes;
        @CommandLine.Option(names={"--relationships"}, arity="1..*", converter={RelationsipFilesConverter.class}, showDefaultValue=CommandLine.Help.Visibility.NEVER, paramLabel="[<type>=]<files>", description={"Relationship CSV header and data. Multiple files will be logically seen as one big file from the perspective of the importer. The first line must contain the header. Multiple data sources like these can be specified in one import, where each data source has its own header."})
        private List<RelationshipFilesGroup> relationships = new ArrayList<RelationshipFilesGroup>();
        @CommandLine.Option(names={"--auto-skip-subsequent-headers"}, arity="0..1", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, paramLabel="true|false", fallbackValue="true", description={"Automatically skip accidental header lines in subsequent files in file groups with more than one file"})
        private boolean autoSkipHeaders;

        Base(ExecutionContext ctx) {
            super(ctx);
        }

        protected Optional<String> commandConfigName() {
            return Optional.of("database-import");
        }

        protected void doExecute(boolean incremental, CsvImporter.IncrementalStage mode, String format, boolean overwriteDestination) {
            try {
                Config databaseConfig = this.loadNeo4jConfig(format);
                Neo4jLayout neo4jLayout = Neo4jLayout.of((Configuration)databaseConfig);
                RecordDatabaseLayout databaseLayout = RecordDatabaseLayout.of((Neo4jLayout)neo4jLayout, (String)this.database.name());
                org.neo4j.csv.reader.Configuration csvConfig = this.csvConfiguration();
                org.neo4j.internal.batchimport.Configuration importConfig = this.importConfiguration();
                CsvImporter.Builder importerBuilder = CsvImporter.builder().withDatabaseLayout((DatabaseLayout)databaseLayout).withDatabaseConfig(databaseConfig).withFileSystem(this.ctx.fs()).withStdOut(this.ctx.out()).withStdErr(this.ctx.err()).withCsvConfig(csvConfig).withImportConfig(importConfig).withIdType(this.idType).withInputEncoding(this.inputEncoding).withReportFile(this.reportFile.toAbsolutePath()).withIgnoreExtraColumns(this.ignoreExtraColumns).withBadTolerance(this.badTolerance).withSkipBadRelationships(this.skipBadRelationships).withSkipDuplicateNodes(this.skipDuplicateNodes).withSkipBadEntriesLogging(this.skipBadEntriesLogging).withSkipBadRelationships(this.skipBadRelationships).withNormalizeTypes(this.normalizeTypes).withVerbose(this.verbose).withAutoSkipHeaders(this.autoSkipHeaders).withForce(overwriteDestination).withIncremental(incremental);
                if (incremental) {
                    importerBuilder.withIncrementalStage(mode);
                }
                this.nodes.forEach(n -> importerBuilder.addNodeFiles((Set)n.key, n.files));
                this.relationships.forEach(n -> importerBuilder.addRelationshipFiles((String)n.key, n.files));
                CsvImporter importer = importerBuilder.build();
                importer.doImport();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @VisibleForTesting
        Config loadNeo4jConfig(String format) {
            Config.Builder builder = this.createPrefilledConfigBuilder();
            if (StringUtils.isNotEmpty((CharSequence)format)) {
                builder.set(GraphDatabaseSettings.db_format, (Object)format);
            }
            return builder.build();
        }

        private org.neo4j.csv.reader.Configuration csvConfiguration() {
            return DEFAULT_CSV_CONFIG.toBuilder().withDelimiter(this.delimiter).withArrayDelimiter(this.arrayDelimiter).withQuotationCharacter(this.quote).withMultilineFields(this.multilineFields).withEmptyQuotedStringsAsNull(this.ignoreEmptyStrings).withTrimStrings(this.trimStrings).withLegacyStyleQuoting(this.legacyStyleQuoting).withBufferSize(Math.toIntExact(this.bufferSize)).build();
        }

        private org.neo4j.internal.batchimport.Configuration importConfiguration() {
            return new Configuration.Overridden(org.neo4j.internal.batchimport.Configuration.defaultConfiguration()){

                public int maxNumberOfWorkerThreads() {
                    return threads;
                }

                public long maxOffHeapMemory() {
                    return maxOffHeapMemory;
                }

                public boolean highIO() {
                    return highIo == OnOffAuto.AUTO ? super.highIO() : highIo == OnOffAuto.ON;
                }

                public IndexConfig indexConfig() {
                    return IndexConfig.create().withLabelIndex().withRelationshipTypeIndex();
                }

                public boolean strictNodeCheck() {
                    return strict;
                }
            };
        }

        static class IdTypeConverter
        implements CommandLine.ITypeConverter<IdType> {
            IdTypeConverter() {
            }

            public IdType convert(String in) {
                try {
                    return IdType.valueOf((String)in.toUpperCase());
                }
                catch (Exception e) {
                    throw new CommandLine.TypeConversionException(String.format("Invalid id type: %s (%s)", in, e));
                }
            }
        }

        static class RelationsipFilesConverter
        implements CommandLine.ITypeConverter<InputFilesGroup<String>> {
            RelationsipFilesConverter() {
            }

            public InputFilesGroup<String> convert(String value) {
                try {
                    return ImportCommand.parseRelationshipFilesGroup(value);
                }
                catch (Exception e) {
                    throw new CommandLine.TypeConversionException(String.format("Invalid relationships file: %s (%s)", value, e));
                }
            }
        }

        static class NodeFilesConverter
        implements CommandLine.ITypeConverter<NodeFilesGroup> {
            NodeFilesConverter() {
            }

            public NodeFilesGroup convert(String value) {
                try {
                    return ImportCommand.parseNodeFilesGroup(value);
                }
                catch (Exception e) {
                    throw new CommandLine.TypeConversionException(String.format("Invalid nodes file: %s (%s)", value, e));
                }
            }
        }

        static class EscapedCharacterConverter
        implements CommandLine.ITypeConverter<Character> {
            EscapedCharacterConverter() {
            }

            public Character convert(String value) {
                return CHARACTER_CONVERTER.apply(value);
            }
        }

        static class OnOffAutoConverter
        implements CommandLine.ITypeConverter<OnOffAuto> {
            OnOffAutoConverter() {
            }

            public OnOffAuto convert(String value) throws Exception {
                return OnOffAuto.valueOf(value.toUpperCase());
            }
        }

        private static enum OnOffAuto {
            ON,
            OFF,
            AUTO;

        }
    }
}

