/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tooling;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.neo4j.csv.reader.Configuration;
import org.neo4j.csv.reader.IllegalMultilineFieldException;
import org.neo4j.function.BiFunction;
import org.neo4j.function.Function;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Args;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Format;
import org.neo4j.helpers.Strings;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.Version;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.StoreLogService;
import org.neo4j.kernel.impl.storemigration.FileOperation;
import org.neo4j.kernel.impl.storemigration.StoreFile;
import org.neo4j.kernel.impl.storemigration.StoreFileType;
import org.neo4j.kernel.impl.util.Converters;
import org.neo4j.kernel.impl.util.OsBeanUtil;
import org.neo4j.kernel.impl.util.Validator;
import org.neo4j.kernel.impl.util.Validators;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.tooling.CharacterConverter;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.ParallelBatchImporter;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.DuplicateInputIdException;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.Collectors;
import org.neo4j.unsafe.impl.batchimport.input.Input;
import org.neo4j.unsafe.impl.batchimport.input.InputEntityDecorators;
import org.neo4j.unsafe.impl.batchimport.input.InputException;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.input.MissingRelationshipDataException;
import org.neo4j.unsafe.impl.batchimport.input.csv.Configuration;
import org.neo4j.unsafe.impl.batchimport.input.csv.CsvInput;
import org.neo4j.unsafe.impl.batchimport.input.csv.DataFactories;
import org.neo4j.unsafe.impl.batchimport.input.csv.DataFactory;
import org.neo4j.unsafe.impl.batchimport.input.csv.IdType;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitors;

public class ImportTool {
    static final String MULTI_FILE_DELIMITER = ",";
    private static final Function<String, IdType> TO_ID_TYPE = new Function<String, IdType>(){

        public IdType apply(String from) {
            return IdType.valueOf((String)from.toUpperCase());
        }
    };
    private static final Function<String, Character> CHARACTER_CONVERTER = new CharacterConverter();
    private static final BiFunction<Args, String, Collection<Args.Option<File[]>>> INPUT_FILES_EXTRACTOR = new BiFunction<Args, String, Collection<Args.Option<File[]>>>(){

        public Collection<Args.Option<File[]>> apply(Args args, String key) {
            return args.interpretOptionsWithMetadata(key, Converters.optional(), Converters.toFiles((String)ImportTool.MULTI_FILE_DELIMITER, (Function)Converters.regexFiles((boolean)true)), new Validator[]{FILES_EXISTS, Validators.atLeast((String)("--" + key), (int)1)});
        }
    };
    static final Validator<File[]> FILES_EXISTS = new Validator<File[]>(){

        public void validate(File[] files) {
            for (File file : files) {
                if (file.getName().startsWith(":")) {
                    ImportTool.warn("It looks like you're trying to specify default label or relationship type (" + file.getName() + "). Please put such directly on the key, f.ex. " + Options.NODE_DATA.argument() + ":MyLabel");
                }
                Validators.REGEX_FILE_EXISTS.validate((Object)file);
            }
        }
    };

    public static void main(String[] incomingArguments) throws IOException {
        ImportTool.main(incomingArguments, false);
    }

    public static void main(String[] incomingArguments, boolean defaultSettingsSuitableForTests) throws IOException {
        Config dbConfig;
        boolean enableStacktrace;
        Collection relationshipsFiles;
        Collection nodesFiles;
        File storeDir;
        Args args = Args.parse((String[])incomingArguments);
        if (ArrayUtil.isEmpty((Object[])incomingArguments) || ImportTool.asksForUsage(args)) {
            ImportTool.printUsage(System.out);
            return;
        }
        DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
        Number processors = null;
        CsvInput input = null;
        OutputStream badOutput = null;
        boolean success = false;
        try {
            storeDir = (File)args.interpretOption(Options.STORE_DIR.key(), Converters.mandatory(), Converters.toFile(), new Validator[]{Validators.DIRECTORY_IS_WRITABLE, Validators.CONTAINS_NO_EXISTING_DATABASE});
            File badFile = new File(storeDir, "bad.log");
            badOutput = new BufferedOutputStream(fs.openAsOutputStream(badFile, false));
            nodesFiles = (Collection)INPUT_FILES_EXTRACTOR.apply((Object)args, (Object)Options.NODE_DATA.key());
            relationshipsFiles = (Collection)INPUT_FILES_EXTRACTOR.apply((Object)args, (Object)Options.RELATIONSHIP_DATA.key());
            ImportTool.validateInputFiles(nodesFiles, relationshipsFiles);
            enableStacktrace = args.getBoolean(Options.STACKTRACE.key(), Boolean.FALSE, Boolean.TRUE);
            processors = args.getNumber(Options.PROCESSORS.key(), null);
            IdType idType = (IdType)args.interpretOption(Options.ID_TYPE.key(), Converters.withDefault((Object)((IdType)Options.ID_TYPE.defaultValue())), TO_ID_TYPE, new Validator[0]);
            int badTolerance = args.getNumber(Options.BAD_TOLERANCE.key(), (Number)Options.BAD_TOLERANCE.defaultValue()).intValue();
            Charset inputEncoding = Charset.forName(args.get(Options.INPUT_ENCODING.key(), Charset.defaultCharset().name()));
            boolean skipBadRelationships = args.getBoolean(Options.SKIP_BAD_RELATIONSHIPS.key(), (Boolean)Options.SKIP_BAD_RELATIONSHIPS.defaultValue(), Boolean.valueOf(true));
            boolean skipDuplicateNodes = args.getBoolean(Options.SKIP_DUPLICATE_NODES.key(), (Boolean)Options.SKIP_DUPLICATE_NODES.defaultValue(), Boolean.valueOf(true));
            boolean ignoreExtraColumns = args.getBoolean(Options.IGNORE_EXTRA_COLUMNS.key(), (Boolean)Options.IGNORE_EXTRA_COLUMNS.defaultValue(), Boolean.valueOf(true));
            Collector badCollector = Collectors.badCollector((OutputStream)badOutput, (int)badTolerance, (int)Collectors.collect((boolean)skipBadRelationships, (boolean)skipDuplicateNodes, (boolean)ignoreExtraColumns));
            input = new CsvInput(ImportTool.nodeData(inputEncoding, nodesFiles), DataFactories.defaultFormatNodeFileHeader(), ImportTool.relationshipData(inputEncoding, relationshipsFiles), DataFactories.defaultFormatRelationshipFileHeader(), idType, ImportTool.csvConfiguration(args, defaultSettingsSuitableForTests), badCollector);
            dbConfig = ImportTool.loadDbConfig((File)args.interpretOption(Options.DATABASE_CONFIG.key(), Converters.optional(), Converters.toFile(), new Validator[]{Validators.REGEX_FILE_EXISTS}));
            success = true;
        }
        catch (IllegalArgumentException e) {
            throw ImportTool.andPrintError("Input error", e, false);
        }
        catch (IOException e) {
            throw ImportTool.andPrintError("File error", e, false);
        }
        finally {
            if (!success && badOutput != null) {
                badOutput.close();
            }
        }
        LifeSupport life = new LifeSupport();
        LogService logService = (LogService)life.add((Lifecycle)StoreLogService.inStoreDirectory((FileSystemAbstraction)fs, (File)storeDir));
        life.start();
        org.neo4j.unsafe.impl.batchimport.Configuration configuration = ImportTool.importConfiguration(processors, defaultSettingsSuitableForTests, dbConfig);
        ParallelBatchImporter importer = new ParallelBatchImporter(storeDir, configuration, logService, ExecutionMonitors.defaultVisible(), dbConfig);
        ImportTool.printOverview(storeDir, nodesFiles, relationshipsFiles);
        success = false;
        try {
            importer.doImport((Input)input);
            success = true;
        }
        catch (Exception e) {
            throw ImportTool.andPrintError("Import error", e, enableStacktrace);
        }
        finally {
            block21: {
                File badFile;
                input.badCollector().close();
                badOutput.close();
                if (input.badCollector().badEntries() > 0 && (badFile = new File(storeDir, "bad.log")).exists()) {
                    System.out.println("There were bad entries which were skipped and logged into " + badFile.getAbsolutePath());
                }
                life.shutdown();
                if (!success) {
                    try {
                        StoreFile.fileOperation((FileOperation)FileOperation.DELETE, (FileSystemAbstraction)fs, (File)storeDir, null, (Iterable)Iterables.iterable((Object[])StoreFile.values()), (boolean)false, (boolean)false, (StoreFileType[])StoreFileType.values());
                    }
                    catch (IOException e) {
                        System.err.println("Unable to delete store files after an aborted import " + e);
                        if (!enableStacktrace) break block21;
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private static Config loadDbConfig(File file) throws IOException {
        return file != null && file.exists() ? new Config(MapUtil.load((File)file)) : new Config();
    }

    private static void printOverview(File storeDir, Collection<Args.Option<File[]>> nodesFiles, Collection<Args.Option<File[]>> relationshipsFiles) {
        System.out.println("Neo4j version: " + Version.getKernel().getReleaseVersion());
        System.out.println("Importing the contents of these files into " + storeDir + ":");
        ImportTool.printInputFiles("Nodes", nodesFiles);
        ImportTool.printInputFiles("Relationships", relationshipsFiles);
        System.out.println();
        System.out.println("Available memory:");
        ImportTool.printIndented("Free machine memory: " + Format.bytes((long)OsBeanUtil.getFreePhysicalMemory()));
        ImportTool.printIndented("Max heap memory : " + Format.bytes((long)Runtime.getRuntime().maxMemory()));
        System.out.println();
    }

    private static void printInputFiles(String name, Collection<Args.Option<File[]>> files) {
        if (files.isEmpty()) {
            return;
        }
        System.out.println(name + ":");
        int i = 0;
        for (Args.Option<File[]> group : files) {
            if (i++ > 0) {
                System.out.println();
            }
            if (group.metadata() != null) {
                ImportTool.printIndented(":" + group.metadata());
            }
            for (File file : (File[])group.value()) {
                ImportTool.printIndented(file);
            }
        }
    }

    private static void printIndented(Object value) {
        System.out.println("  " + value);
    }

    private static void validateInputFiles(Collection<Args.Option<File[]>> nodesFiles, Collection<Args.Option<File[]>> relationshipsFiles) {
        if (nodesFiles.isEmpty()) {
            if (relationshipsFiles.isEmpty()) {
                throw new IllegalArgumentException("No input specified, nothing to import");
            }
            throw new IllegalArgumentException("No node input specified, cannot import relationships without nodes");
        }
    }

    private static org.neo4j.unsafe.impl.batchimport.Configuration importConfiguration(final Number processors, final boolean defaultSettingsSuitableForTests, final Config dbConfig) {
        return new Configuration.Default(){

            public long pageCacheMemory() {
                return defaultSettingsSuitableForTests ? ByteUnit.mebiBytes((long)8L) : super.pageCacheMemory();
            }

            public int maxNumberOfProcessors() {
                return processors != null ? processors.intValue() : super.maxNumberOfProcessors();
            }

            public int denseNodeThreshold() {
                return (Integer)dbConfig.get(GraphDatabaseSettings.dense_node_threshold);
            }
        };
    }

    private static String manualReference(ManualPage page, Anchor anchor) {
        return " http://neo4j.com/docs/" + Version.getKernel().getReleaseVersion() + "/" + page.getReference(anchor);
    }

    private static RuntimeException andPrintError(String typeOfError, Exception e, boolean stackTrace) {
        if (DuplicateInputIdException.class.equals(e.getClass())) {
            ImportTool.printErrorMessage("Duplicate input ids that would otherwise clash can be put into separate id space, read more about how to use id spaces in the manual:" + ImportTool.manualReference(ManualPage.IMPORT_TOOL_FORMAT, Anchor.ID_SPACES), e, stackTrace);
        } else if (MissingRelationshipDataException.class.equals(e.getClass())) {
            ImportTool.printErrorMessage("Relationship missing mandatory field '" + ((MissingRelationshipDataException)e).getFieldType() + "', read more about " + "relationship format in the manual: " + ImportTool.manualReference(ManualPage.IMPORT_TOOL_FORMAT, Anchor.RELATIONSHIP), e, stackTrace);
        } else if (Exceptions.contains((Throwable)e, (Class[])new Class[]{IllegalMultilineFieldException.class})) {
            ImportTool.printErrorMessage("Detected field which spanned multiple lines for an import where " + Options.MULTILINE_FIELDS.argument() + "=false. If you know that your input data " + "include fields containing new-line characters then import with this option set to " + "true.", e, stackTrace);
        } else if (Exceptions.contains((Throwable)e, (Class[])new Class[]{InputException.class})) {
            ImportTool.printErrorMessage("Error in input data", e, stackTrace);
        } else {
            ImportTool.printErrorMessage(typeOfError + ": " + e.getMessage(), e, true);
        }
        System.err.println();
        Thread.currentThread().setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
            }
        });
        return Exceptions.launderedException((Throwable)e);
    }

    private static void printErrorMessage(String string, Exception e, boolean stackTrace) {
        System.err.println(string);
        System.err.println("Caused by:" + e.getMessage());
        if (stackTrace) {
            e.printStackTrace(System.err);
        }
    }

    private static Iterable<DataFactory<InputRelationship>> relationshipData(final Charset encoding, Collection<Args.Option<File[]>> relationshipsFiles) {
        return new IterableWrapper<DataFactory<InputRelationship>, Args.Option<File[]>>(relationshipsFiles){

            protected DataFactory<InputRelationship> underlyingObjectToObject(Args.Option<File[]> group) {
                return DataFactories.data((Function)InputEntityDecorators.defaultRelationshipType((String)group.metadata()), (Charset)encoding, (File[])((File[])group.value()));
            }
        };
    }

    private static Iterable<DataFactory<InputNode>> nodeData(final Charset encoding, Collection<Args.Option<File[]>> nodesFiles) {
        return new IterableWrapper<DataFactory<InputNode>, Args.Option<File[]>>(nodesFiles){

            protected DataFactory<InputNode> underlyingObjectToObject(Args.Option<File[]> input) {
                Function decorator = input.metadata() != null ? InputEntityDecorators.additiveLabels((String[])input.metadata().split(":")) : InputEntityDecorators.NO_NODE_DECORATOR;
                return DataFactories.data((Function)decorator, (Charset)encoding, (File[])((File[])input.value()));
            }
        };
    }

    private static void printUsage(PrintStream out) {
        out.println("Neo4j Import Tool");
        for (String string : Args.splitLongLine((String)"neo4j-import is used to create a new Neo4j database from data in CSV files. See the chapter \"Import Tool\" in the Neo4j Manual for details on the CSV file format - a special kind of header is required.", (int)80)) {
            out.println("\t" + string);
        }
        out.println("Usage:");
        for (Options options : Options.values()) {
            options.printUsage(out);
        }
        out.println("Example:");
        out.print(Strings.joinAsLines((String[])new String[]{"\tbin/neo4j-import --into retail.db --id-type string --nodes:Customer customers.csv ", "\t--nodes products.csv --nodes orders_header.csv,orders1.csv,orders2.csv ", "\t--relationships:CONTAINS order_details.csv ", "\t--relationships:ORDERED customer_orders_header.csv,orders1.csv,orders2.csv"}));
    }

    private static boolean asksForUsage(Args args) {
        for (String string : args.orphans()) {
            if (!ImportTool.isHelpKey(string)) continue;
            return true;
        }
        for (Map.Entry entry : args.asMap().entrySet()) {
            if (!ImportTool.isHelpKey((String)entry.getKey())) continue;
            return true;
        }
        return false;
    }

    private static boolean isHelpKey(String key) {
        return key.equals("?") || key.equals("help");
    }

    private static org.neo4j.unsafe.impl.batchimport.input.csv.Configuration csvConfiguration(Args args, final boolean defaultSettingsSuitableForTests) {
        final org.neo4j.unsafe.impl.batchimport.input.csv.Configuration defaultConfiguration = org.neo4j.unsafe.impl.batchimport.input.csv.Configuration.COMMAS;
        final Character specificDelimiter = (Character)args.interpretOption(Options.DELIMITER.key(), Converters.optional(), CHARACTER_CONVERTER, new Validator[0]);
        final Character specificArrayDelimiter = (Character)args.interpretOption(Options.ARRAY_DELIMITER.key(), Converters.optional(), CHARACTER_CONVERTER, new Validator[0]);
        final Character specificQuote = (Character)args.interpretOption(Options.QUOTE.key(), Converters.optional(), CHARACTER_CONVERTER, new Validator[0]);
        final Boolean multiLineFields = args.getBoolean(Options.MULTILINE_FIELDS.key(), null);
        final Boolean emptyStringsAsNull = args.getBoolean(Options.IGNORE_EMPTY_STRINGS.key(), null);
        return new Configuration.Default(){

            public char delimiter() {
                return specificDelimiter != null ? specificDelimiter.charValue() : defaultConfiguration.delimiter();
            }

            public char arrayDelimiter() {
                return specificArrayDelimiter != null ? specificArrayDelimiter.charValue() : defaultConfiguration.arrayDelimiter();
            }

            public char quotationCharacter() {
                return specificQuote != null ? specificQuote.charValue() : defaultConfiguration.quotationCharacter();
            }

            public boolean multilineFields() {
                return multiLineFields != null ? multiLineFields.booleanValue() : defaultConfiguration.multilineFields();
            }

            public boolean emptyQuotedStringsAsNull() {
                return emptyStringsAsNull != null ? emptyStringsAsNull.booleanValue() : defaultConfiguration.emptyQuotedStringsAsNull();
            }

            public int bufferSize() {
                return defaultSettingsSuitableForTests ? 10000 : super.bufferSize();
            }
        };
    }

    static void warn(String warning) {
        System.err.println(warning);
    }

    private static enum Anchor {
        ID_SPACES("import-tool-id-spaces"),
        RELATIONSHIP("import-tool-header-format-rels");

        private final String anchor;

        private Anchor(String anchor) {
            this.anchor = anchor;
        }
    }

    private static enum ManualPage {
        IMPORT_TOOL_FORMAT("import-tool-header-format.html");

        private final String page;

        private ManualPage(String page) {
            this.page = page;
        }

        public String getReference(Anchor anchor) {
            return this.page + "#" + anchor.anchor;
        }
    }

    static enum Options {
        STORE_DIR("into", null, "<store-dir>", "Database directory to import into. Must not contain existing database."),
        NODE_DATA("nodes", null, "[:Label1:Label2] \"<file1>,<file2>,...\"", "Node CSV header and data. Multiple files will be logically seen as one big file from the perspective of the importer. The first line must contain the header. Multiple data sources like these can be specified in one import, where each data source has its own header. Note that file groups must be enclosed in quotation marks.", true),
        RELATIONSHIP_DATA("relationships", null, "[:RELATIONSHIP_TYPE] \"<file1>,<file2>,...\"", "Relationship CSV header and data. Multiple files will be logically seen as one big file from the perspective of the importer. The first line must contain the header. Multiple data sources like these can be specified in one import, where each data source has its own header. Note that file groups must be enclosed in quotation marks.", true),
        DELIMITER("delimiter", null, "<delimiter-character>", "Delimiter character, or 'TAB', between values in CSV data. The default option is `" + org.neo4j.unsafe.impl.batchimport.input.csv.Configuration.COMMAS.delimiter() + "`."),
        ARRAY_DELIMITER("array-delimiter", null, "<array-delimiter-character>", "Delimiter character, or 'TAB', between array elements within a value in CSV data. The default option is `" + org.neo4j.unsafe.impl.batchimport.input.csv.Configuration.COMMAS.arrayDelimiter() + "`."),
        QUOTE("quote", null, "<quotation-character>", "Character to treat as quotation character for values in CSV data. The default option is `" + org.neo4j.unsafe.impl.batchimport.input.csv.Configuration.COMMAS.quotationCharacter() + "`. " + "Quotes inside quotes escaped like `\"\"\"Go away\"\", he said.\"` and " + "`\"\\\"Go away\\\", he said.\"` are supported. " + "If you have set \"`'`\" to be used as the quotation character, " + "you could write the previous example like this instead: " + "`'\"Go away\", he said.'`"),
        MULTILINE_FIELDS("multiline-fields", Configuration.DEFAULT.multilineFields(), "<true/false>", "Whether or not fields from input source can span multiple lines, i.e. contain newline characters."),
        INPUT_ENCODING("input-encoding", null, "<character set>", "Character set that input data is encoded in. Provided value must be one out of the available character sets in the JVM, as provided by Charset#availableCharsets(). If no input encoding is provided, the default character set of the JVM will be used."),
        IGNORE_EMPTY_STRINGS("ignore-empty-strings", Configuration.DEFAULT.emptyQuotedStringsAsNull(), "<true/false>", "Whether or not empty string fields, i.e. \"\" from input source are ignored, i.e. treated as null."),
        ID_TYPE("id-type", IdType.STRING, "<id-type>", "One out of " + Arrays.toString(IdType.values()) + " and specifies how ids in node/relationship " + "input files are treated.\n" + IdType.STRING + ": arbitrary strings for identifying nodes.\n" + IdType.INTEGER + ": arbitrary integer values for identifying nodes.\n" + IdType.ACTUAL + ": (advanced) actual node ids. The default option is `" + IdType.STRING + "`."),
        PROCESSORS("processors", null, "<max processor count>", "(advanced) Max number of processors used by the importer. Defaults to the number of available processors reported by the JVM" + Options.availableProcessorsHint() + ". There is a certain amount of minimum threads needed so for that reason there " + "is no lower bound for this value. For optimal performance this value shouldn't be " + "greater than the number of available processors."),
        STACKTRACE("stacktrace", null, "<true/false>", "Enable printing of error stack traces."),
        BAD_TOLERANCE("bad-tolerance", 1000, "<max number of bad entries>", "Number of bad entries before the import is considered failed. This tolerance threshold is about relationships refering to missing nodes. Format errors in input data are still treated as errors"),
        SKIP_BAD_RELATIONSHIPS("skip-bad-relationships", Boolean.TRUE, "<true/false>", "Whether or not to skip importing relationships that refers to missing node ids, i.e. either start or end node id/group referring to node that wasn't specified by the node input data. Skipped nodes will be logged, containing at most number of entites specified by " + BAD_TOLERANCE.key() + "."),
        SKIP_DUPLICATE_NODES("skip-duplicate-nodes", Boolean.FALSE, "<true/false>", "Whether or not to skip importing nodes that have the same id/group. In the event of multiple nodes within the same group having the same id, the first encountered will be imported whereas consecutive such nodes will be skipped. Skipped nodes will be logged, containing at most number of entities specified by " + BAD_TOLERANCE.key() + "."),
        IGNORE_EXTRA_COLUMNS("ignore-extra-columns", Boolean.FALSE, "<true/false>", "Whether or not to ignore extra columns in the data not specified by the header. Skipped columns will be logged, containing at most number of entities specified by " + BAD_TOLERANCE.key() + "."),
        DATABASE_CONFIG("db-config", null, "<path/to/neo4j.properties>", "(advanced) File specifying database-specific configuration. For more information consult manual about available configuration options for a neo4j configuration file. Only configuration affecting store at time of creation will be read. Examples of supported config are:\n" + GraphDatabaseSettings.dense_node_threshold.name() + "\n" + GraphDatabaseSettings.string_block_size.name() + "\n" + GraphDatabaseSettings.array_block_size.name());

        private final String key;
        private final Object defaultValue;
        private final String usage;
        private final String description;
        private final boolean keyAndUsageGoTogether;

        private Options(String key, Object defaultValue, String usage, String description) {
            this(key, defaultValue, usage, description, false);
        }

        private Options(String key, Object defaultValue, String usage, String description, boolean keyAndUsageGoTogether) {
            this.key = key;
            this.defaultValue = defaultValue;
            this.usage = usage;
            this.description = description;
            this.keyAndUsageGoTogether = keyAndUsageGoTogether;
        }

        String key() {
            return this.key;
        }

        String argument() {
            return "--" + this.key();
        }

        void printUsage(PrintStream out) {
            out.println(this.argument() + this.spaceInBetweenArgumentAndUsage() + this.usage);
            for (String line : Args.splitLongLine((String)this.descriptionWithDefaultValue().replace("`", ""), (int)80)) {
                out.println("\t" + line);
            }
        }

        private String spaceInBetweenArgumentAndUsage() {
            return this.keyAndUsageGoTogether ? "" : " ";
        }

        String descriptionWithDefaultValue() {
            String result = this.description;
            if (this.defaultValue != null) {
                if (!result.endsWith(".")) {
                    result = result + ".";
                }
                result = result + " Default value: " + this.defaultValue;
            }
            return result;
        }

        String manPageEntry() {
            String filteredDescription = this.descriptionWithDefaultValue().replace(Options.availableProcessorsHint(), "");
            String usageString = this.usage.length() > 0 ? this.spaceInBetweenArgumentAndUsage() + this.usage : "";
            return "*" + this.argument() + usageString + "*::\n" + filteredDescription + "\n\n";
        }

        String manualEntry() {
            return "[[import-tool-option-" + this.key() + "]]\n" + this.manPageEntry() + "//^\n\n";
        }

        Object defaultValue() {
            return this.defaultValue;
        }

        private static String availableProcessorsHint() {
            return " (in your case " + Runtime.getRuntime().availableProcessors() + ")";
        }
    }
}

