/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.io.PrintStream;
import java.util.function.BiFunction;
import org.neo4j.annotations.api.PublicApi;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.impl.StandardExpander;
import org.neo4j.graphdb.traversal.BranchState;
import org.neo4j.graphdb.traversal.Paths;

@PublicApi
public abstract class PathExpanders {
    public static <STATE> PathExpander<STATE> allTypesAndDirections() {
        return StandardExpander.DEFAULT;
    }

    public static <STATE> PathExpander<STATE> forType(RelationshipType type) {
        return StandardExpander.create(type, Direction.BOTH);
    }

    public static <STATE> PathExpander<STATE> forDirection(Direction direction) {
        return StandardExpander.create(direction);
    }

    public static <STATE> PathExpander<STATE> forTypeAndDirection(RelationshipType type, Direction direction) {
        return StandardExpander.create(type, direction);
    }

    public static <STATE> PathExpander<STATE> forTypesAndDirections(RelationshipType type1, Direction direction1, RelationshipType type2, Direction direction2, Object ... more) {
        return StandardExpander.create(type1, direction1, type2, direction2, more);
    }

    public static <STATE> PathExpander<STATE> forConstantDirectionWithTypes(final RelationshipType ... types) {
        return new PathExpander<STATE>(){

            @Override
            public ResourceIterable<Relationship> expand(Path path, BranchState<STATE> state) {
                if (path.length() == 0) {
                    return path.endNode().getRelationships(types);
                }
                Direction direction = this.getDirectionOfLastRelationship(path);
                return path.endNode().getRelationships(direction, types);
            }

            @Override
            public PathExpander<STATE> reverse() {
                return this;
            }

            private Direction getDirectionOfLastRelationship(Path path) {
                assert (path.length() > 0);
                Direction direction = Direction.INCOMING;
                if (path.endNode().equals(path.lastRelationship().getEndNode())) {
                    direction = Direction.OUTGOING;
                }
                return direction;
            }
        };
    }

    private PathExpanders() {
    }

    public static <STATE> PathExpander<STATE> printingWrapper(PathExpander<STATE> source) {
        return PathExpanders.printingWrapper(source, new Paths.DefaultPathDescriptor());
    }

    public static <STATE> PathExpander<STATE> printingWrapper(PathExpander<STATE> source, BiFunction<Path, BranchState, Boolean> pred) {
        return PathExpanders.printingWrapper(source, pred, new Paths.DefaultPathDescriptor());
    }

    public static <STATE> PathExpander<STATE> printingWrapper(PathExpander<STATE> source, Paths.PathDescriptor descriptor) {
        return PathExpanders.printingWrapper(source, (entities, stateBranchState) -> Boolean.TRUE, descriptor);
    }

    public static <STATE> PathExpander<STATE> printingWrapper(PathExpander<STATE> source, BiFunction<Path, BranchState, Boolean> pred, Paths.PathDescriptor descriptor) {
        return PathExpanders.printingWrapper(source, pred, descriptor, System.out);
    }

    public static <STATE> PathExpander<STATE> printingWrapper(final PathExpander<STATE> source, final BiFunction<Path, BranchState, Boolean> pred, final Paths.PathDescriptor descriptor, final PrintStream out) {
        return new PathExpander<STATE>(){

            @Override
            public ResourceIterable<Relationship> expand(Path path, BranchState state) {
                if (((Boolean)pred.apply(path, state)).booleanValue()) {
                    out.println(Paths.pathToString(path, descriptor));
                }
                return source.expand(path, state);
            }

            @Override
            public PathExpander<STATE> reverse() {
                return PathExpanders.printingWrapper(source.reverse(), pred, descriptor, out);
            }
        };
    }
}

